<div class="ste-m-0 stax-main <?php echo esc_attr( implode( ' ', $wrapper_class ) ); ?>">
	<div class="ste-mt-5 ste-mb-4">
		<div class="ste-container ste-mx-auto ste-bg-white ste-rounded ste-shadow-lg ste-overflow-hidden">
			<div class="ste-flex ste-justify-between ste-items-center ste-p-10">
				<a href="<?php echo esc_url( $site_url ); ?>" target="_blank" rel="noopener"
				   class="ste-text-base ste-flex ste-items-center ste-content-center ste-no-underline focus:ste-shadow-none">
					<span class="ste-inline-block ste-w-60">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 521.31 78.81"><defs><style>.cls-1{fill:#2f3565;}.cls-2{fill:#03a9f4;}</style></defs><g id="Layer_2" data-name="Layer 2"><g id="StaxWP"><path class="cls-1" d="M116.77,25.85a14.75,14.75,0,0,1,5,6.95A29.64,29.64,0,0,1,123.43,43v.76q0,9.25-3.75,14.55t-11.33,5.3a11,11,0,0,1-9.26-4.74l-.54,4H87.06V7.75H99.91V27.07a10.76,10.76,0,0,1,8.37-3.73A13.83,13.83,0,0,1,116.77,25.85Zm-7.34,10.27c-.74-1.63-2.21-2.44-4.38-2.44q-3.7,0-5.14,2.51V50.88a4.4,4.4,0,0,0,2,1.84,7.48,7.48,0,0,0,3.23.6,4.93,4.93,0,0,0,3.54-1.12,5.52,5.52,0,0,0,1.52-3.08,31.29,31.29,0,0,0,.36-5.35V43A17.1,17.1,0,0,0,109.43,36.12Z"/><path class="cls-1" d="M163.79,24.05V62.9h-12l-.4-4.27a12.58,12.58,0,0,1-4.43,3.7,12.9,12.9,0,0,1-5.8,1.29q-6.07,0-9.55-3.52T128.1,49.19V24.05H141V49.26a3.84,3.84,0,0,0,1.14,2.94,4.84,4.84,0,0,0,3.42,1.08q3.84,0,5.31-2.51V24.05Z"/><path class="cls-1" d="M204.93,7.75V62.9H193.37l-.65-4.31q-3.69,5-9.26,5a13.31,13.31,0,0,1-8.2-2.51,15.31,15.31,0,0,1-5.07-7A28.49,28.49,0,0,1,168.49,44v-.76a29.42,29.42,0,0,1,1.69-10.46,14.71,14.71,0,0,1,5.06-6.93,13.69,13.69,0,0,1,8.29-2.46A10.65,10.65,0,0,1,192,27.43V7.75Zm-15,44.78a5.27,5.27,0,0,0,2.1-2.16V36.69a5.24,5.24,0,0,0-5.2-3q-5.46,0-5.46,9.51V44a16,16,0,0,0,1.2,6.87,4.29,4.29,0,0,0,4.19,2.46A6.38,6.38,0,0,0,189.9,52.53Z"/><path class="cls-1" d="M246.25,7.75V62.9H234.69l-.64-4.31q-3.7,5-9.27,5a13.33,13.33,0,0,1-8.2-2.51,15.23,15.23,0,0,1-5.06-7A28.27,28.27,0,0,1,209.81,44v-.76a29.64,29.64,0,0,1,1.69-10.46,14.71,14.71,0,0,1,5.06-6.93,13.72,13.72,0,0,1,8.3-2.46,10.66,10.66,0,0,1,8.47,4.09V7.75Zm-15,44.78a5.27,5.27,0,0,0,2.1-2.16V36.69a5.25,5.25,0,0,0-5.21-3q-5.46,0-5.45,9.51V44a16,16,0,0,0,1.2,6.87,4.26,4.26,0,0,0,4.18,2.46A6.45,6.45,0,0,0,231.23,52.53Z"/><path class="cls-1" d="M288.51,24.05l-15.62,44.6a23.92,23.92,0,0,1-2.22,4.77,11,11,0,0,1-3.95,3.63,13.53,13.53,0,0,1-6.86,1.54,18,18,0,0,1-2.51-.11,26.74,26.74,0,0,1-2.69-.64V68.29l1.58,0a8.38,8.38,0,0,0,3.8-.64,3.75,3.75,0,0,0,1.69-1.87l.93-2.33L249.13,24.05h13.78l5.75,20.69,6.06-20.69Z"/><path class="cls-2" d="M321.09,25.85a14.69,14.69,0,0,1,5,6.95A29.4,29.4,0,0,1,327.75,43v.76q0,9.25-3.75,14.55t-11.33,5.3a11,11,0,0,1-9.26-4.74l-.54,4H291.38V7.75h12.86V27.07a10.73,10.73,0,0,1,8.36-3.73A13.83,13.83,0,0,1,321.09,25.85Zm-7.34,10.27q-1.11-2.44-4.38-2.44c-2.46,0-4.18.84-5.13,2.51V50.88a4.38,4.38,0,0,0,2,1.84,7.54,7.54,0,0,0,3.23.6A4.93,4.93,0,0,0,313,52.2a5.47,5.47,0,0,0,1.53-3.08,31.29,31.29,0,0,0,.36-5.35V43A17.08,17.08,0,0,0,313.75,36.12Z"/><path class="cls-2" d="M368.11,24.05V62.9h-12l-.39-4.27a12.52,12.52,0,0,1-4.44,3.7,12.87,12.87,0,0,1-5.8,1.29q-6.06,0-9.55-3.52t-3.48-10.91V24.05h12.89V49.26a3.81,3.81,0,0,0,1.15,2.94,4.81,4.81,0,0,0,3.41,1.08q3.84,0,5.31-2.51V24.05Z"/><path class="cls-2" d="M385,8.44a6.18,6.18,0,0,1,3.45,5.63,6.35,6.35,0,0,1-.9,3.38,6.14,6.14,0,0,1-2.53,2.3,8.71,8.71,0,0,1-7.38,0,6.15,6.15,0,0,1-3.44-5.68,6.17,6.17,0,0,1,.91-3.33,6.26,6.26,0,0,1,2.53-2.3,8,8,0,0,1,3.7-.83A7.89,7.89,0,0,1,385,8.44ZM374.93,62.9V24.05h12.93V62.9Z"/><path class="cls-2" d="M395.47,62.9V7.75h12.92V62.9Z"/><path class="cls-2" d="M450.33,7.75V62.9H438.77l-.65-4.31q-3.69,5-9.26,5a13.36,13.36,0,0,1-8.21-2.51,15.37,15.37,0,0,1-5.06-7A28.27,28.27,0,0,1,413.89,44v-.76a29.65,29.65,0,0,1,1.68-10.46,14.8,14.8,0,0,1,5.07-6.93,13.67,13.67,0,0,1,8.29-2.46,10.66,10.66,0,0,1,8.47,4.09V7.75Zm-15,44.78a5.27,5.27,0,0,0,2.1-2.16V36.69a5.25,5.25,0,0,0-5.2-3q-5.46,0-5.46,9.51V44a16,16,0,0,0,1.2,6.87,4.27,4.27,0,0,0,4.18,2.46A6.45,6.45,0,0,0,435.3,52.53Z"/><path class="cls-2" d="M492.41,47.79H468.82a7.08,7.08,0,0,0,2.82,4,8.77,8.77,0,0,0,5.11,1.42,14,14,0,0,0,4.9-.86,9.22,9.22,0,0,0,3.93-2.8l5.71,7.5a14.05,14.05,0,0,1-3.53,3.21,20.25,20.25,0,0,1-5.3,2.43,22.39,22.39,0,0,1-6.57.93A22,22,0,0,1,465,61,17.79,17.79,0,0,1,458,54.12a18.82,18.82,0,0,1-2.43-9.38V43.41a24.13,24.13,0,0,1,2.09-10.18A16.33,16.33,0,0,1,464,26a19.57,19.57,0,0,1,10.56-2.67A19.06,19.06,0,0,1,484,25.6a15.14,15.14,0,0,1,6.21,6.53,22.16,22.16,0,0,1,2.18,10.16Zm-18-14a4.94,4.94,0,0,0-4,1.58,8.73,8.73,0,0,0-1.76,4.31h11.21v-1C480,35.36,478.15,33.75,474.42,33.75Z"/><path class="cls-2" d="M521.31,23.73l-.22,12.64-1-.07c-1.39-.15-2.42-.22-3.09-.22a11.58,11.58,0,0,0-4.61.77,5,5,0,0,0-2.53,2.39V62.9H497V24.05h12l.43,5.14A11.49,11.49,0,0,1,513,24.84a8.37,8.37,0,0,1,4.87-1.5A12.39,12.39,0,0,1,521.31,23.73Z"/><path class="cls-1" d="M62.48,42.82c-.45-.46-1-1-1.67-1.6C57.7,38.34,53,34,53,29v-.11a8.71,8.71,0,0,1,2.88-6.32c4.38-4.3,6.65-8.59,6.65-12.4a8.7,8.7,0,0,0-.66-3.38C60.17,2.73,55.38,0,49.9,0H11.72l-6,.14L4.59,3.31A11,11,0,0,1,5.68,4.67c1.81,2.77,1.51,6.68,1.38,8.69-1,15.58-5.28,35.46-7,45.83a6.61,6.61,0,0,0-.08,1,2,2,0,0,0,.32,1.24c.41.48,1.45.74,3,.74H31c6.15,0,13.78,0,16-3.33a4.77,4.77,0,0,0,.68-2.66A16.87,16.87,0,0,0,46,49.8c-4.25-9.39-14-13.13-14.15-13.17a2,2,0,0,0-.43-.07,7.82,7.82,0,0,0-1.18.18l-.44.06a13.81,13.81,0,0,1-1.82.14A13.38,13.38,0,1,1,41.34,23.55h0a12.58,12.58,0,0,1-.09,1.5,4.11,4.11,0,0,1-.07.47c0,.33-.1.65-.18,1s-.09.36-.13.53-.17.59-.26.88l-.19.53c-.12.29-.24.59-.37.84s-.15.32-.23.47c-.16.3-.32.59-.5.87l-.21.35a13.23,13.23,0,0,1-.84,1.13l-.15.16a11,11,0,0,1-.81.87l-.37.34-.68.59c-.06,0-.1.08-.09.13s0,.07.08.11A30.38,30.38,0,0,1,49.63,48.16a20.16,20.16,0,0,1,2.09,8.05A8.72,8.72,0,0,1,50.37,61c-3,4.64-10.07,5.11-16.89,5.16H31.26c-4.84,0-13.8-.31-19.92-.6a13.62,13.62,0,0,0-1,5.86,20.36,20.36,0,0,0,.28,3.21q.21,1.32.54,2.61l.26.89,1.6.65a7.47,7.47,0,0,0,.79-.6,5,5,0,0,1,1-.59,8.24,8.24,0,0,1,1.37-.48,11.39,11.39,0,0,1,2-.31c.83-.07,1.78-.12,2.91-.12s4.3-.09,9.16,0c5,.14,12.66.24,12.66.24C54.52,77,62.06,69,65,62.14a21.33,21.33,0,0,0,1.78-8.33A15.62,15.62,0,0,0,62.48,42.82ZM21.79,41.58c3.66,4.83-1.62,4.35-4.56,2.07C13.81,41,16.33,34.55,21.79,41.58ZM13.92,57.14c-7.38,3.21-15.68-6.62.66-9.26C25.73,46.21,20.26,54.38,13.92,57.14Z"/><path class="cls-2" d="M28,14.22a9.36,9.36,0,1,0,9.38,9.35h0A9.38,9.38,0,0,0,28,14.22Z"/></g></g></svg>
					</span>
				</a>

				<div class="ste-text-right">
					<h1 class="ste-block ste-leading-normal ste-my-0"><span class="ste-font-light">Welcome to</span> STAX</h1>
					<div class="ste-font-medium ste-text-lg ste-text-gray-600">Build BuddyPress Pages with Elementor</div>
				</div>
			</div>
			<ul class="ste-flex ste-overflow-hidden ste-bg-gradient-to-r ste-from-blue-500 ste-to-indigo-500 ste-m-0">
				<?php foreach ( $menu as $item ) : ?>
					<?php
						$active_class = $item['query'] === $_GET['page'] ? 'ste-bg-blue-700' : '';
					?>
					<li class="ste-flex ste-mb-0">
						<a href="<?php echo esc_url( $item['link'] ); ?>" class="ste-no-underline ste-text-white ste-font-medium ste-py-4 ste-px-6 ste-leading-normal focus:ste-shadow-none hover:ste-bg-blue-700 hover:ste-text-white <?php echo esc_attr( $active_class ); ?>">
							<?php echo $item['name']; ?>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	</div>

	<?php do_action( BPB_HOOK_PREFIX . 'before_panel_action' ); ?>

	<?php do_action( BPB_HOOK_PREFIX . 'panel_action' ); ?>

	<?php do_action( BPB_HOOK_PREFIX . 'after_panel_action' ); ?>

	<div class="ste-container ste-mx-auto ste-my-10">
		<div class="ste-flex ste-justify-center">
			<div class="ste-text-gray-400 ste-text-sm">
				<?php printf( __( 'Version %s', 'stax-buddy-builder' ), BPB_VERSION ); ?>
			</div>
		</div>
	</div>
</div>
