<h2 class="ste-my-0 ste-leading-none ste-text-2xl ste-text-gray-900 ste-font-bold ste-tracking-wide">
	<?php esc_html_e( 'Templates', 'stax-buddy-builder' ); ?>
</h2>

<div class="ste-mt-5">
	<div class="ste-grid ste-grid-cols-2 lg:ste-grid-cols-3 ste-gap-4">
		<?php foreach ( $templates as $template ) : ?>
			<div class="ste-rounded ste-shadow hover:ste-shadow-lg ste-overflow-hidden">
				<div class="ste-aspect-w-16 ste-aspect-h-9">
					<img class="ste-w-full ste-object-cover" src="<?php echo esc_url( $template['image'] ); ?>">
				</div>
				<div class="ste-bg-ash-100 ste-p-4">
					<div class="ste-text-center ste-mb-8 ste-mt-2">
						<h3 class="ste-m-0 ste-text-gray-800">
							<?php echo esc_html( $template['name'] ); ?>
						</h3>
					</div>

					<div class="ste-text-center">
						<?php
						if ( $template['is_imported'] ) {
							$text = esc_html__( 'Import again', 'stax-buddy-builder' );
						} else {
							$text = esc_html__( 'Import', 'stax-buddy-builder' );
						}
						?>

						<div class="ste-grid ste-grid-cols-2 ste-gap-2">
							<a href="<?php echo esc_url( $template['url'] ); ?>"
								class="bpb-import-starter ste-flex ste-items-center ste-justify-center ste-no-underline ste-bg-gradient-to-r ste-from-green-500 ste-to-green-400 ste-text-md ste-text-white hover:ste-text-white ste-font-bold ste-py-3 ste-px-6 ste-rounded">
								<i class="eicon-download-bold ste-mr-2"></i>
								<?php echo $text; ?>
							</a>

							<?php if ( isset( $template['demo'] ) && $template['demo'] ) : ?>
								<a href="<?php echo esc_url( $template['demo'] ); ?>"
									target="_blank"             
									class="ste-flex ste-items-center ste-justify-center ste-no-underline ste-bg-gradient-to-r ste-from-neutral-300 ste-to-neutral-200 ste-text-md ste-text-neutral-700 hover:ste-text-neutral-700 ste-font-bold ste-py-3 ste-px-6 ste-rounded">
									<i class="eicon-preview-medium ste-mr-2"></i>
									<?php esc_html_e( 'Demo', 'stax-buddy-builder' ); ?>
								</a>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>
