const withTW = require( '@bsf/force-ui/withTW' );

module.exports = withTW( {
	content: [ './src/**/*.{html,js}' ],
	plugins: [],
	theme: {
		extend: {
			colors: {
				// brand
				'brand-background-50': '#E7E0FA',
				'brand-background-hover-100': '#EFD7F9',
				'brand-200': '#E8CFF8',
				'brand-border-300': '#E0C6F6',
				'brand-800': '#1E40AF',
				'brand-900': '#232250',
				'brand-text-950': '#141338',
				// background
				'background-primary': '#FFFFFF',
				'background-secondary': '#F3F3F8',
				'background-inverse': '#141338',
				'background-brand': '#5C2EDE',
				// field
				'field-primary-background': '#F9FAFC',
				'field-secondary-background': '#FFFFFF',
				'field-primary-hover': '#F3F3F8',
				'field-secondary-hover': '#F9FAFC',
				'field-dropzone-background': '#FFFFFF',
				'field-border': '#E6E6EF',
				'field-dropzone-background-hover': '#F9FAFC',
				'field-dropzone-color': '#5C2EDE',
				'field-label': '#4F4E7C',
				'field-input': '#141338',
				'field-helper': '#9F9FBF',
				'field-background-disabled': '#F9FAFC',
				'field-color-disabled': '#BDC1C7',
				'field-placeholder': '#9F9FBF',
				'field-border-disabled': '#F3F3F8',
				'field-color-error': '#DC2626',
				'field-border-error': '#FECACA',
				'field-background-error': '#FEF2F2',
				'field-required': '#DC2626',
				// border
				'border-interactive': '#5C2EDE',
				'border-subtle': '#E6E6EF',
				'border-strong': '#6B7280',
				'border-inverse': '#374151',
				'border-disabled': '#E5E7EB',
				'border-muted': '#E6E6EF',
				'border-error': '#FECACA',
				'border-transparent-subtle': '#37415114',
				'border-white': '#FFFFFF',
				// text
				'text-primary': '#141338',
				'text-secondary': '#4F4E7C',
				'text-tertiary': '#9F9FBF',
				'text-on-color': '#FFFFFF',
				'text-error': '#DC2626',
				'text-error-inverse': '#F87171',
				'text-inverse': '#FFFFFF',
				'text-disabled': '#BDC1C7',
				'text-on-button-disabled': '#6F6B99',
				// link
				'link-primary': '#5C2EDE',
				'link-primary-hover': '#AD38E2',
				'link-inverse': '#38BDF8',
				'link-visited': '#7C3AED',
				'link-visited-inverse': '#A78BFA',
				'link-inverse-hover': '#7DD3FC',
				// icon
				'icon-primary': '#141338',
				'icon-secondary': '#6F6B99',
				'icon-on-color': '#FFFFFF',
				'icon-inverse': '#9F9FBF',
				'icon-interactive': '#5C2EDE',
				'icon-on-color-disabled': '#9F9FBF',
				'icon-disabled': '#D1D5DB',
				// support
				'support-error': '#DC2626',
				'support-success': '#16A34A',
				'support-warning': '#EAB308',
				'support-info': '#0284C7',
				'support-error-inverse': '#F87171',
				'support-success-inverse': '#4ADE80',
				'support-warning-inverse': '#FDE047',
				'support-info-inverse': '#38BDF8',
				// button
				'button-primary': '#5C2EDE',
				'button-primary-hover': '#AD38E2',
				'button-secondary': '#EFD7F9',
				'button-secondary-hover': '#3B3A6A',
				'button-tertiary': '#FFFFFF',
				'button-tertiary-hover': '#F3F3F8',
				'button-active': '#F3F4F6',
				'button-danger': '#DC2626',
				'button-danger-secondary': '#DC2626',
				'button-danger-hover': '#B91C1C',
				'button-disabled': '#F3F3F8',
				'button-tertiary-border': '#E6E6EF',
				'button-tertiary-color': '#141338',
				// focus
				focus: '#5C2EDE',
				'focus-inset': '#FFFFFF',
				'focus-inverse': '#38BDF8',
				'focus-inverse-inset': '#141338',
				'focus-error': '#DC2626',
				'focus-border': '#E8CFF8',
				'focus-error-border': '#FECACA',
				// misc
				'misc-highlight': '#E8CFF8',
				'misc-overlay': '#111827BF',
				'misc-skeleton-background': '#F3F3F8',
				'misc-skeleton-element': '#D2D3E2',
				'misc-popup-button-hover': '#1118270D',
				'misc-tab-item-hover': '#F3F3F8',
				'misc-dropdown-hover': '#F3F3F8',
				'misc-loader-base': '#1118270D',
				'misc-loader-color': '#5C2EDE',
				'misc-progress-background': '#E6E6EF',
				// badge
				'badge-background-gray': '#F9FAFC',
				'badge-color-gray': '#232250',
				'badge-hover-gray': '#F3F3F8',
				'badge-border-gray': '#E6E6EF',
				'badge-background-red': '#FEF2F2',
				'badge-color-red': '#B91C1C',
				'badge-hover-red': '#FEE2E2',
				'badge-border-red': '#FECACA',
				'badge-background-yellow': '#FEFCE8',
				'badge-color-yellow': '#A16207',
				'badge-hover-yellow': '#FEF9C3',
				'badge-border-yellow': '#FEF08A',
				'badge-hover-green': '#DCFCE7',
				'badge-border-green': '#BBF7D0',
				'badge-background-green': '#F0FDF4',
				'badge-color-green': '#15803D',
				'badge-background-sky': '#F0F9FF',
				'badge-color-sky': '#0369A1',
				'badge-hover-sky': '#E0F2FE',
				'badge-border-sky': '#BAE6FD',
				'badge-background-disabled': '#F3F3F8',
				'badge-color-disabled': '#BDC1C7',
				'badge-hover-disabled': '#F3F3F8',
				'badge-border-disabled': '#E6E6EF',
				// alert
				'alert-background-neutral': '#FFFFFF',
				'alert-border-neutral': '#E6E6EF',
				'alert-background-danger': '#FEF2F2',
				'alert-border-danger': '#FECACA',
				'alert-background-warning': '#FEFCE8',
				'alert-border-warning': '#FEF08A',
				'alert-background-green': '#F0FDF4',
				'alert-border-green': '#BBF7D0',
				'alert-background-info': '#F0F9FF',
				'alert-border-info': '#BAE6FD',
				// tab
				'tab-background': '#F9FAFC',
				'tab-border': '#E6E6EF',
				// tooltip
				'tooltip-background-light': '#FFFFFF',
				'tooltip-background-dark': '#141338',
				// toggle
				'toggle-off': '#EFD7F9',
				'toggle-on': '#5C2EDE',
				'toggle-dial-background': '#FFFFFF',
				'toggle-off-hover': '#E8CFF8',
				'toggle-off-border': '#E8CFF8',
				'toggle-on-hover': '#5C2EDE',
				'toggle-on-border': '#634AE0',
				'toggle-on-disabled': '#E7E0FA',
				'toggle-off-disabled': '#F3F3F8',
				astra: {
					DEFAULT: '#5C2EDE',
					hover: '#AD38E2',
				},
			},
			width: {
				'1/7': '14.2857143%',
				'1/8': '12.5%',
				'1/9': '11.1111111%',
				'1/10': '10%',
				'1/11': '9.0909091%',
				'1/12': '8.3333333%',
			},
			fontFamily: {
				figtree: [ '"Figtree"', 'Inter', 'sans-serif' ],
			},
			boxShadow: {
				'soft-shadow-sm': '0px 6px 32px -12px rgba(149, 160, 178, 0.12)',
				'soft-shadow': '0px 8px 32px -12px rgba(149, 160, 178, 0.16)',
				'soft-shadow-md': '0px 10px 32px -12px rgba(149, 160, 178, 0.2)',
				'soft-shadow-lg': '0px 12px 32px -12px rgba(149, 160, 178, 0.24)',
				'soft-shadow-xl': '0px 16px 32px -12px rgba(149, 160, 178, 0.32)',
				'soft-shadow-2xl': '0px 24px 64px -12px rgba(149, 160, 178, 0.32)',
				'soft-shadow-inner': '0px 1px 1px 0px rgba(0, 0, 0, 0.05)',
				'overlay-left': '-16px 0px 80px -24px rgba(0, 0, 0, 0.16)',
				'overlay-right': '16px 0px 80px -24px rgba(0, 0, 0, 0.16)',
				hover: '0px 12px 24px -12px rgba(0, 0, 0, 0.12)',
				'overlay-light': '0px 2px 4px -2px rgba(16, 24, 40, 0.06)',
				'overlay-modal': '0px 32px 64px -24px rgba(0, 0, 0, 0.24)',
			},

		},
	},
	variants: {
		extend: {},
	},
	important: '#ast-tb-app-root',
} );
