<?php
/**
 *  Class that add Payment Icons functionality.
 *
 * @package Neve_Pro\Modules\Woocommerce_Booster\Views
 */

namespace Neve_Pro\Modules\Woocommerce_Booster\Views;

use Neve\Views\Base_View;

/**
 * Class Payment_Icons
 *
 * @package Neve_Pro\Modules\Woocommerce_Booster\Views
 */
class Payment_Icons extends Base_View {

	/**
	 * SVG of payment icons
	 *
	 * @var array
	 */
	private static $payment_icons;

	/**
	 * Check if submodule should be loaded.
	 *
	 * @return bool
	 */
	private static function should_load() {
		if ( ! class_exists( 'Woocommerce' ) ) {
			return false;
		}

		if ( ! is_cart() ) {
			return false;
		}

		$payment_icons = get_theme_mod( 'neve_enable_payment_icons', false );
		return $payment_icons;
	}

	/**
	 * Payment_Icons constructor.
	 */
	public function __construct() {
		self::$payment_icons = apply_filters(
			'neve_payment_icons',
			array(
				'visa'             => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M10.781 7.688c-0.251-1.283-1.219-1.688-2.344-1.688h-8.376l-0.061 0.405c5.749 1.469 10.469 4.595 12.595 10.501l-1.813-9.219zM13.125 19.688l-0.531-2.781c-1.096-2.907-3.752-5.594-6.752-6.813l4.219 15.939h5.469l8.157-20.032h-5.501l-5.062 13.688zM27.72 26.061l3.248-20.061h-5.187l-3.251 20.061h5.189zM41.875 5.656c-5.125 0-8.717 2.72-8.749 6.624-0.032 2.877 2.563 4.469 4.531 5.439 2.032 0.968 2.688 1.624 2.688 2.499 0 1.344-1.624 1.939-3.093 1.939-2.093 0-3.219-0.251-4.875-1.032l-0.688-0.344-0.719 4.499c1.219 0.563 3.437 1.064 5.781 1.064 5.437 0.032 8.97-2.688 9.032-6.843 0-2.282-1.405-4-4.376-5.439-1.811-0.904-2.904-1.563-2.904-2.499 0-0.843 0.936-1.72 2.968-1.72 1.688-0.029 2.936 0.314 3.875 0.752l0.469 0.248 0.717-4.344c-1.032-0.406-2.656-0.844-4.656-0.844zM55.813 6c-1.251 0-2.189 0.376-2.72 1.688l-7.688 18.374h5.437c0.877-2.467 1.096-3 1.096-3 0.592 0 5.875 0 6.624 0 0 0 0.157 0.688 0.624 3h4.813l-4.187-20.061h-4zM53.405 18.938c0 0 0.437-1.157 2.064-5.594-0.032 0.032 0.437-1.157 0.688-1.907l0.374 1.72c0.968 4.781 1.189 5.781 1.189 5.781-0.813 0-3.283 0-4.315 0z"></path></svg>',
				'visa-electron'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M25.569 23.917h2.98v0.784h-2.196l-0.314 1.725h1.725l-0.157 0.784h-1.725l-0.157 1.882h2.196v0.784h-3.137l0.783-5.96zM29.804 29.094h2.353l-0.157 0.784h-3.137l0.784-5.961h0.941l-0.784 5.177zM33.725 23.917h3.137l-0.157 0.784h-2.196l-0.157 1.725h1.725l-0.157 0.784h-1.725l-0.314 1.882h2.353l-0.157 0.784h-3.137l0.784-5.96zM38.431 24.701c0.627-0.627 1.307-0.941 2.039-0.941 0.627 0 1.15 0.211 1.569 0.627l-0.47 0.784c-0.419-0.417-0.839-0.627-1.255-0.627-1.255 0-1.987 0.784-2.196 2.353-0.105 0.627 0 1.176 0.314 1.647s0.73 0.706 1.255 0.706c0.522 0 1.043-0.26 1.569-0.784v1.098c-0.419 0.314-0.941 0.47-1.569 0.47-1.78 0-2.565-1.044-2.353-3.137 0.102-0.836 0.47-1.568 1.098-2.196zM42.98 23.917h4.392l-0.157 0.784h-1.882l-0.627 5.176h-0.941l0.784-5.176h-1.725l0.157-0.784zM51.451 24.701c0.209 0.525 0.157 1.074-0.157 1.647-0.314 0.576-0.733 0.917-1.255 1.020l1.412 2.51h-0.941l-1.412-2.51h-0.47l-0.314 2.51h-0.784l0.784-5.961h1.882c0.628 0 1.043 0.262 1.255 0.784zM50.353 26.113c0.522-0.941 0.416-1.412-0.314-1.412h-0.941l-0.314 1.882h0.941l0.627-0.47zM57.882 26.898c-0.419 2.093-1.412 3.137-2.98 3.137-0.733 0-1.333-0.314-1.804-0.941s-0.654-1.357-0.549-2.196c0.416-2.091 1.412-3.137 2.98-3.137 1.778 0 2.562 1.046 2.353 3.137zM56.784 25.172c-0.314-0.522-0.733-0.784-1.255-0.784-1.255 0-1.987 0.838-2.196 2.51-0.105 0.627 0 1.203 0.314 1.725 0.314 0.525 0.73 0.784 1.255 0.784 1.255 0 1.984-0.836 2.196-2.51 0.102-0.627 0.001-1.201-0.314-1.725zM64 23.917l-0.784 5.961h-0.784l-2.196-4.549-0.784 4.549h-0.784l0.941-5.961h0.784l2.039 4.392 0.784-4.392h0.783zM59.921 16.074h0.157v0.157h-0.157v0.157h0.157v0.157h0.157l-0.157-0.157 0.157-0.157c0-0.103-0.055-0.157-0.157-0.157h-0.314v0.47h0.157v-0.47zM10.781 3.997c-0.251-1.283-1.219-1.688-2.344-1.688h-8.376l-0.061 0.406c5.749 1.469 10.469 4.594 12.595 10.501l-1.813-9.219zM13.125 15.997l-0.531-2.781c-1.096-2.907-3.752-5.594-6.752-6.813l4.219 15.939h5.469l8.157-20.032h-5.501l-5.062 13.688zM27.72 22.37l3.248-20.061h-5.187l-3.251 20.061h5.189zM41.875 1.965c-5.125 0-8.717 2.72-8.749 6.624-0.032 2.877 2.563 4.469 4.531 5.439 2.032 0.968 2.688 1.624 2.688 2.499 0 1.344-1.624 1.939-3.093 1.939-2.093 0-3.219-0.251-4.875-1.032l-0.688-0.344-0.72 4.499c1.219 0.563 3.437 1.064 5.781 1.064 5.437 0.032 8.97-2.688 9.032-6.843 0-2.282-1.405-4-4.376-5.439-1.811-0.904-2.904-1.563-2.904-2.499 0-0.843 0.936-1.72 2.968-1.72 1.688-0.029 2.936 0.314 3.875 0.752l0.469 0.248 0.717-4.344c-1.031-0.406-2.655-0.844-4.655-0.844zM55.813 2.309c-1.251 0-2.189 0.376-2.72 1.688l-7.688 18.374h5.437c0.877-2.467 1.096-3 1.096-3 0.592 0 5.875 0 6.624 0 0 0 0.157 0.688 0.624 3h4.813l-4.187-20.061h-4zM53.405 15.247c0 0 0.437-1.157 2.064-5.594-0.032 0.032 0.437-1.157 0.688-1.907l0.374 1.72c0.968 4.781 1.189 5.781 1.189 5.781-0.813 0-3.283 0-4.315 0z"></path></svg>',
				'paypal'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M35.255 12.078h-2.396c-0.229 0-0.444 0.114-0.572 0.303l-3.306 4.868-1.4-4.678c-0.088-0.292-0.358-0.493-0.663-0.493h-2.355c-0.284 0-0.485 0.28-0.393 0.548l2.638 7.745-2.481 3.501c-0.195 0.275 0.002 0.655 0.339 0.655h2.394c0.227 0 0.439-0.111 0.569-0.297l7.968-11.501c0.191-0.275-0.006-0.652-0.341-0.652zM19.237 16.718c-0.23 1.362-1.311 2.276-2.691 2.276-0.691 0-1.245-0.223-1.601-0.644-0.353-0.417-0.485-1.012-0.374-1.674 0.214-1.35 1.313-2.294 2.671-2.294 0.677 0 1.227 0.225 1.589 0.65 0.365 0.428 0.509 1.027 0.404 1.686zM22.559 12.078h-2.384c-0.204 0-0.378 0.148-0.41 0.351l-0.104 0.666-0.166-0.241c-0.517-0.749-1.667-1-2.817-1-2.634 0-4.883 1.996-5.321 4.796-0.228 1.396 0.095 2.731 0.888 3.662 0.727 0.856 1.765 1.212 3.002 1.212 2.123 0 3.3-1.363 3.3-1.363l-0.106 0.662c-0.040 0.252 0.155 0.479 0.41 0.479h2.147c0.341 0 0.63-0.247 0.684-0.584l1.289-8.161c0.040-0.251-0.155-0.479-0.41-0.479zM8.254 12.135c-0.272 1.787-1.636 1.787-2.957 1.787h-0.751l0.527-3.336c0.031-0.202 0.205-0.35 0.41-0.35h0.345c0.899 0 1.747 0 2.185 0.511 0.262 0.307 0.341 0.761 0.242 1.388zM7.68 7.473h-4.979c-0.341 0-0.63 0.248-0.684 0.584l-2.013 12.765c-0.040 0.252 0.155 0.479 0.41 0.479h2.378c0.34 0 0.63-0.248 0.683-0.584l0.543-3.444c0.053-0.337 0.343-0.584 0.683-0.584h1.575c3.279 0 5.172-1.587 5.666-4.732 0.223-1.375 0.009-2.456-0.635-3.212-0.707-0.832-1.962-1.272-3.628-1.272zM60.876 7.823l-2.043 12.998c-0.040 0.252 0.155 0.479 0.41 0.479h2.055c0.34 0 0.63-0.248 0.683-0.584l2.015-12.765c0.040-0.252-0.155-0.479-0.41-0.479h-2.299c-0.205 0.001-0.379 0.148-0.41 0.351zM54.744 16.718c-0.23 1.362-1.311 2.276-2.691 2.276-0.691 0-1.245-0.223-1.601-0.644-0.353-0.417-0.485-1.012-0.374-1.674 0.214-1.35 1.313-2.294 2.671-2.294 0.677 0 1.227 0.225 1.589 0.65 0.365 0.428 0.509 1.027 0.404 1.686zM58.066 12.078h-2.384c-0.204 0-0.378 0.148-0.41 0.351l-0.104 0.666-0.167-0.241c-0.516-0.749-1.667-1-2.816-1-2.634 0-4.883 1.996-5.321 4.796-0.228 1.396 0.095 2.731 0.888 3.662 0.727 0.856 1.765 1.212 3.002 1.212 2.123 0 3.3-1.363 3.3-1.363l-0.106 0.662c-0.040 0.252 0.155 0.479 0.41 0.479h2.147c0.341 0 0.63-0.247 0.684-0.584l1.289-8.161c0.040-0.252-0.156-0.479-0.41-0.479zM43.761 12.135c-0.272 1.787-1.636 1.787-2.957 1.787h-0.751l0.527-3.336c0.031-0.202 0.205-0.35 0.41-0.35h0.345c0.899 0 1.747 0 2.185 0.511 0.261 0.307 0.34 0.761 0.241 1.388zM43.187 7.473h-4.979c-0.341 0-0.63 0.248-0.684 0.584l-2.013 12.765c-0.040 0.252 0.156 0.479 0.41 0.479h2.554c0.238 0 0.441-0.173 0.478-0.408l0.572-3.619c0.053-0.337 0.343-0.584 0.683-0.584h1.575c3.279 0 5.172-1.587 5.666-4.732 0.223-1.375 0.009-2.456-0.635-3.212-0.707-0.832-1.962-1.272-3.627-1.272z"></path></svg>',
				'stripe'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M7.114 14.656c-1.375-0.5-2.125-0.906-2.125-1.531 0-0.531 0.437-0.812 1.188-0.812 1.437 0 2.875 0.531 3.875 1.031l0.563-3.5c-0.781-0.375-2.406-1-4.656-1-1.594 0-2.906 0.406-3.844 1.188-1 0.812-1.5 2-1.5 3.406 0 2.563 1.563 3.688 4.125 4.594 1.625 0.594 2.188 1 2.188 1.656 0 0.625-0.531 0.969-1.5 0.969-1.188 0-3.156-0.594-4.437-1.343l-0.563 3.531c1.094 0.625 3.125 1.281 5.25 1.281 1.688 0 3.063-0.406 4.031-1.157 1.063-0.843 1.594-2.062 1.594-3.656-0.001-2.625-1.595-3.719-4.188-4.657zM21.114 9.125h-3v-4.219l-4.031 0.656-0.563 3.563-1.437 0.25-0.531 3.219h1.937v6.844c0 1.781 0.469 3 1.375 3.75 0.781 0.625 1.907 0.938 3.469 0.938 1.219 0 1.937-0.219 2.468-0.344v-3.688c-0.282 0.063-0.938 0.22-1.375 0.22-0.906 0-1.313-0.5-1.313-1.563v-6.156h2.406l0.595-3.469zM30.396 9.031c-0.313-0.062-0.594-0.093-0.876-0.093-1.312 0-2.374 0.687-2.781 1.937l-0.313-1.75h-4.093v14.719h4.687v-9.563c0.594-0.719 1.437-0.968 2.563-0.968 0.25 0 0.5 0 0.812 0.062v-4.344zM33.895 2.719c-1.375 0-2.468 1.094-2.468 2.469s1.094 2.5 2.468 2.5 2.469-1.124 2.469-2.5-1.094-2.469-2.469-2.469zM36.239 23.844v-14.719h-4.687v14.719h4.687zM49.583 10.468c-0.843-1.094-2-1.625-3.469-1.625-1.343 0-2.531 0.563-3.656 1.75l-0.25-1.469h-4.125v20.155l4.688-0.781v-4.719c0.719 0.219 1.469 0.344 2.125 0.344 1.157 0 2.876-0.313 4.188-1.75 1.281-1.375 1.907-3.5 1.907-6.313 0-2.499-0.469-4.405-1.407-5.593zM45.677 19.532c-0.375 0.687-0.969 1.094-1.625 1.094-0.468 0-0.906-0.093-1.281-0.281v-7c0.812-0.844 1.531-0.938 1.781-0.938 1.188 0 1.781 1.313 1.781 3.812 0.001 1.437-0.219 2.531-0.656 3.313zM62.927 10.843c-1.032-1.312-2.563-2-4.501-2-4 0-6.468 2.938-6.468 7.688 0 2.625 0.656 4.625 1.968 5.875 1.157 1.157 2.844 1.719 5.032 1.719 2 0 3.844-0.469 5-1.251l-0.501-3.219c-1.157 0.625-2.5 0.969-4 0.969-0.906 0-1.532-0.188-1.969-0.594-0.5-0.406-0.781-1.094-0.875-2.062h7.75c0.031-0.219 0.062-1.281 0.062-1.625 0.001-2.344-0.5-4.188-1.499-5.5zM56.583 15.094c0.125-2.093 0.687-3.062 1.75-3.062s1.625 1 1.687 3.062h-3.437z"></path></svg>',
				'mastercard'       => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M42.667-0c-4.099 0-7.836 1.543-10.667 4.077-2.831-2.534-6.568-4.077-10.667-4.077-8.836 0-16 7.163-16 16s7.164 16 16 16c4.099 0 7.835-1.543 10.667-4.077 2.831 2.534 6.568 4.077 10.667 4.077 8.837 0 16-7.163 16-16s-7.163-16-16-16zM11.934 19.828l0.924-5.809-2.112 5.809h-1.188v-5.809l-1.056 5.809h-1.584l1.32-7.657h2.376v4.753l1.716-4.753h2.508l-1.32 7.657h-1.585zM19.327 18.244c-0.088 0.528-0.178 0.924-0.264 1.188v0.396h-1.32v-0.66c-0.353 0.528-0.924 0.792-1.716 0.792-0.442 0-0.792-0.132-1.056-0.396-0.264-0.351-0.396-0.792-0.396-1.32 0-0.792 0.218-1.364 0.66-1.716 0.614-0.44 1.364-0.66 2.244-0.66h0.66v-0.396c0-0.351-0.353-0.528-1.056-0.528-0.442 0-1.012 0.088-1.716 0.264 0.086-0.351 0.175-0.792 0.264-1.32 0.703-0.264 1.32-0.396 1.848-0.396 1.496 0 2.244 0.616 2.244 1.848 0 0.353-0.046 0.749-0.132 1.188-0.089 0.616-0.179 1.188-0.264 1.716zM24.079 15.076c-0.264-0.086-0.66-0.132-1.188-0.132s-0.792 0.177-0.792 0.528c0 0.177 0.044 0.31 0.132 0.396l0.528 0.264c0.792 0.442 1.188 1.012 1.188 1.716 0 1.409-0.838 2.112-2.508 2.112-0.792 0-1.366-0.044-1.716-0.132 0.086-0.351 0.175-0.836 0.264-1.452 0.703 0.177 1.188 0.264 1.452 0.264 0.614 0 0.924-0.175 0.924-0.528 0-0.175-0.046-0.308-0.132-0.396-0.178-0.175-0.396-0.308-0.66-0.396-0.792-0.351-1.188-0.924-1.188-1.716 0-1.407 0.792-2.112 2.376-2.112 0.792 0 1.32 0.045 1.584 0.132l-0.265 1.451zM27.512 15.208h-0.924c0 0.442-0.046 0.838-0.132 1.188 0 0.088-0.022 0.264-0.066 0.528-0.046 0.264-0.112 0.442-0.198 0.528v0.528c0 0.353 0.175 0.528 0.528 0.528 0.175 0 0.35-0.044 0.528-0.132l-0.264 1.452c-0.264 0.088-0.66 0.132-1.188 0.132-0.881 0-1.32-0.44-1.32-1.32 0-0.528 0.086-1.099 0.264-1.716l0.66-4.225h1.584l-0.132 0.924h0.792l-0.132 1.585zM32.66 17.32h-3.3c0 0.442 0.086 0.749 0.264 0.924 0.264 0.264 0.66 0.396 1.188 0.396s1.1-0.175 1.716-0.528l-0.264 1.584c-0.442 0.177-1.012 0.264-1.716 0.264-1.848 0-2.772-0.924-2.772-2.773 0-1.142 0.264-2.024 0.792-2.64 0.528-0.703 1.188-1.056 1.98-1.056 0.703 0 1.274 0.22 1.716 0.66 0.35 0.353 0.528 0.881 0.528 1.584 0.001 0.617-0.046 1.145-0.132 1.585zM35.3 16.132c-0.264 0.97-0.484 2.201-0.66 3.697h-1.716l0.132-0.396c0.35-2.463 0.614-4.4 0.792-5.809h1.584l-0.132 0.924c0.264-0.44 0.528-0.703 0.792-0.792 0.264-0.264 0.528-0.308 0.792-0.132-0.088 0.088-0.31 0.706-0.66 1.848-0.353-0.086-0.661 0.132-0.925 0.66zM41.241 19.697c-0.353 0.177-0.838 0.264-1.452 0.264-0.881 0-1.584-0.308-2.112-0.924-0.528-0.528-0.792-1.32-0.792-2.376 0-1.32 0.35-2.42 1.056-3.3 0.614-0.879 1.496-1.32 2.64-1.32 0.44 0 1.056 0.132 1.848 0.396l-0.264 1.584c-0.528-0.264-1.012-0.396-1.452-0.396-0.707 0-1.235 0.264-1.584 0.792-0.353 0.442-0.528 1.144-0.528 2.112 0 0.616 0.132 1.056 0.396 1.32 0.264 0.353 0.614 0.528 1.056 0.528 0.44 0 0.924-0.132 1.452-0.396l-0.264 1.717zM47.115 15.868c-0.046 0.264-0.066 0.484-0.066 0.66-0.088 0.442-0.178 1.035-0.264 1.782-0.088 0.749-0.178 1.254-0.264 1.518h-1.32v-0.66c-0.353 0.528-0.924 0.792-1.716 0.792-0.442 0-0.792-0.132-1.056-0.396-0.264-0.351-0.396-0.792-0.396-1.32 0-0.792 0.218-1.364 0.66-1.716 0.614-0.44 1.32-0.66 2.112-0.66h0.66c0.086-0.086 0.132-0.218 0.132-0.396 0-0.351-0.353-0.528-1.056-0.528-0.442 0-1.012 0.088-1.716 0.264 0-0.351 0.086-0.792 0.264-1.32 0.703-0.264 1.32-0.396 1.848-0.396 1.496 0 2.245 0.616 2.245 1.848 0.001 0.089-0.021 0.264-0.065 0.529zM49.69 16.132c-0.178 0.528-0.396 1.762-0.66 3.697h-1.716l0.132-0.396c0.35-1.935 0.614-3.872 0.792-5.809h1.584c0 0.353-0.046 0.66-0.132 0.924 0.264-0.44 0.528-0.703 0.792-0.792 0.35-0.175 0.614-0.218 0.792-0.132-0.353 0.442-0.574 1.056-0.66 1.848-0.353-0.086-0.66 0.132-0.925 0.66zM54.178 19.828l0.132-0.528c-0.353 0.442-0.838 0.66-1.452 0.66-0.707 0-1.188-0.218-1.452-0.66-0.442-0.614-0.66-1.232-0.66-1.848 0-1.142 0.308-2.067 0.924-2.773 0.44-0.703 1.056-1.056 1.848-1.056 0.528 0 1.056 0.264 1.584 0.792l0.264-2.244h1.716l-1.32 7.657h-1.585zM16.159 17.98c0 0.442 0.175 0.66 0.528 0.66 0.35 0 0.614-0.132 0.792-0.396 0.264-0.264 0.396-0.66 0.396-1.188h-0.397c-0.881 0-1.32 0.31-1.32 0.924zM31.076 15.076c-0.088 0-0.178-0.043-0.264-0.132h-0.264c-0.528 0-0.881 0.353-1.056 1.056h1.848v-0.396l-0.132-0.264c-0.001-0.086-0.047-0.175-0.133-0.264zM43.617 17.98c0 0.442 0.175 0.66 0.528 0.66 0.35 0 0.614-0.132 0.792-0.396 0.264-0.264 0.396-0.66 0.396-1.188h-0.396c-0.881 0-1.32 0.31-1.32 0.924zM53.782 15.076c-0.353 0-0.66 0.22-0.924 0.66-0.178 0.264-0.264 0.749-0.264 1.452 0 0.792 0.264 1.188 0.792 1.188 0.35 0 0.66-0.175 0.924-0.528 0.264-0.351 0.396-0.879 0.396-1.584-0.001-0.792-0.311-1.188-0.925-1.188z"></path></svg>',
				'cash-on-delivery' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M13.043 8.356c-0.46 0-0.873 0.138-1.24 0.413s-0.662 0.681-0.885 1.217c-0.223 0.536-0.334 1.112-0.334 1.727 0 0.568 0.119 0.99 0.358 1.265s0.619 0.413 1.141 0.413c0.508 0 1.096-0.131 1.765-0.393v1.327c-0.693 0.262-1.389 0.393-2.089 0.393-0.884 0-1.572-0.254-2.063-0.763s-0.736-1.229-0.736-2.161c0-0.892 0.181-1.712 0.543-2.462s0.846-1.32 1.452-1.709 1.302-0.584 2.089-0.584c0.435 0 0.822 0.038 1.159 0.115s0.7 0.217 1.086 0.421l-0.616 1.276c-0.369-0.201-0.673-0.333-0.914-0.398s-0.478-0.097-0.715-0.097zM19.524 12.842h-2.47l-0.898 1.776h-1.671l3.999-7.491h1.948l0.767 7.491h-1.551l-0.125-1.776zM19.446 11.515l-0.136-1.786c-0.035-0.445-0.052-0.876-0.052-1.291v-0.184c-0.153 0.408-0.343 0.84-0.569 1.296l-0.982 1.965h1.739zM27.049 12.413c0 0.711-0.257 1.273-0.773 1.686s-1.213 0.62-2.094 0.62c-0.769 0-1.389-0.153-1.859-0.46v-1.398c0.672 0.367 1.295 0.551 1.869 0.551 0.39 0 0.694-0.072 0.914-0.217s0.329-0.343 0.329-0.595c0-0.147-0.024-0.275-0.070-0.385s-0.114-0.214-0.201-0.309c-0.087-0.095-0.303-0.269-0.648-0.52-0.481-0.337-0.818-0.67-1.013-1s-0.293-0.685-0.293-1.066c0-0.439 0.108-0.831 0.324-1.176s0.523-0.614 0.922-0.806 0.857-0.288 1.376-0.288c0.755 0 1.446 0.168 2.073 0.505l-0.569 1.189c-0.543-0.252-1.044-0.378-1.504-0.378-0.289 0-0.525 0.077-0.71 0.23s-0.276 0.355-0.276 0.607c0 0.207 0.058 0.389 0.172 0.543s0.372 0.36 0.773 0.615c0.421 0.272 0.736 0.572 0.945 0.9s0.313 0.712 0.313 1.151zM33.969 14.618h-1.597l0.7-3.22h-2.46l-0.7 3.22h-1.592l1.613-7.46h1.597l-0.632 2.924h2.459l0.632-2.924h1.592l-1.613 7.46zM46.319 9.831c0 0.963-0.172 1.824-0.517 2.585s-0.816 1.334-1.415 1.722c-0.598 0.388-1.288 0.582-2.067 0.582-0.891 0-1.587-0.251-2.086-0.753s-0.749-1.198-0.749-2.090c0-0.902 0.172-1.731 0.517-2.488s0.82-1.338 1.425-1.743c0.605-0.405 1.306-0.607 2.099-0.607 0.888 0 1.575 0.245 2.063 0.735s0.73 1.176 0.73 2.056zM43.395 8.356c-0.421 0-0.808 0.155-1.159 0.467s-0.627 0.739-0.828 1.283-0.3 1.135-0.3 1.771c0 0.5 0.116 0.877 0.348 1.133s0.558 0.383 0.979 0.383 0.805-0.148 1.151-0.444c0.346-0.296 0.617-0.714 0.812-1.255s0.292-1.148 0.292-1.822c0-0.483-0.113-0.856-0.339-1.12-0.227-0.264-0.546-0.396-0.957-0.396zM53.427 14.618h-1.786l-1.859-5.644h-0.031l-0.021 0.163c-0.111 0.735-0.227 1.391-0.344 1.97l-0.757 3.511h-1.436l1.613-7.46h1.864l1.775 5.496h0.021c0.042-0.259 0.109-0.628 0.203-1.107s0.407-1.942 0.94-4.388h1.43l-1.613 7.461zM13.296 20.185c0 0.98-0.177 1.832-0.532 2.556s-0.868 1.274-1.539 1.652c-0.672 0.379-1.464 0.568-2.376 0.568h-2.449l1.678-7.68h2.15c0.977 0 1.733 0.25 2.267 0.751s0.801 1.219 0.801 2.154zM8.925 23.615c0.536 0 1.003-0.133 1.401-0.399s0.71-0.657 0.934-1.174c0.225-0.517 0.337-1.108 0.337-1.773 0-0.54-0.131-0.95-0.394-1.232s-0.64-0.423-1.132-0.423h-0.624l-1.097 5.001h0.575zM18.64 24.96h-4.436l1.678-7.68h4.442l-0.293 1.334h-2.78l-0.364 1.686h2.59l-0.299 1.334h-2.59l-0.435 1.98h2.78l-0.293 1.345zM20.509 24.96l1.678-7.68h1.661l-1.39 6.335h2.78l-0.294 1.345h-4.436zM26.547 24.96l1.694-7.68h1.656l-1.694 7.68h-1.656zM33.021 23.389c0.282-0.774 0.481-1.27 0.597-1.487l2.346-4.623h1.716l-4.061 7.68h-1.814l-0.689-7.68h1.602l0.277 4.623c0.015 0.157 0.022 0.39 0.022 0.699-0.007 0.361-0.018 0.623-0.033 0.788h0.038zM41.678 24.96h-4.437l1.678-7.68h4.442l-0.293 1.334h-2.78l-0.364 1.686h2.59l-0.299 1.334h-2.59l-0.435 1.98h2.78l-0.293 1.345zM45.849 22.013l-0.646 2.947h-1.656l1.678-7.68h1.949c0.858 0 1.502 0.179 1.933 0.536s0.646 0.881 0.646 1.571c0 0.554-0.15 1.029-0.451 1.426s-0.733 0.692-1.298 0.885l1.417 3.263h-1.803l-1.124-2.947h-0.646zM46.137 20.689h0.424c0.474 0 0.843-0.1 1.108-0.3s0.396-0.504 0.396-0.914c0-0.287-0.086-0.502-0.258-0.646s-0.442-0.216-0.812-0.216h-0.402l-0.456 2.076zM53.712 20.39l2.031-3.11h1.857l-3.355 4.744-0.646 2.936h-1.645l0.646-2.936-1.281-4.744h1.694l0.7 3.11z"></path></svg>',
				'amazon'           => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 64 32"><path d="M9.315 16.3c-0.401 0.401-0.901 0.803-1.502 1.202-0.101 0.1-0.251 0.15-0.451 0.15-0.3-0.3-0.652-0.751-1.052-1.352-1.002 0.901-2.103 1.352-3.305 1.352-2.005 0-3.005-1-3.005-3.005 0-1.502 0.7-2.604 2.103-3.305 0.3-0.099 1.552-0.3 3.756-0.601v-0.3c0-0.7-0.101-1.15-0.3-1.352-0.101-0.399-0.451-0.601-1.052-0.601-0.901 0-1.453 0.401-1.652 1.202 0 0.202-0.1 0.3-0.3 0.3l-1.953-0.15c-0.202 0-0.3-0.15-0.3-0.451 0.399-2.003 1.902-3.005 4.507-3.005 1.301 0 2.303 0.352 3.005 1.051 0.5 0.502 0.751 1.603 0.751 3.305v3.155c0 0.502 0.25 1.103 0.751 1.803 0.198 0.202 0.198 0.401-0.001 0.601zM5.859 12.244c-2.004 0-3.005 0.701-3.005 2.103 0 0.901 0.399 1.352 1.202 1.352 0.601 0 1.101-0.3 1.502-0.901 0.2-0.399 0.3-1.101 0.3-2.103v-0.451zM39.962 20.957c0-0.399-0.251-0.5-0.751-0.3-4.307 1.704-8.614 2.554-12.92 2.554-6.11 0-11.668-1.45-16.676-4.357l-0.451-0.15c-0.3 0.1-0.3 0.3 0 0.601 4.808 4.207 10.416 6.31 16.826 6.31 5.508 0 10.066-1.352 13.672-4.056 0.2-0.2 0.3-0.399 0.3-0.601zM11.268 17.652h1.953c0.3 0 0.451-0.15 0.451-0.451v-5.409c0-1.803 0.451-2.704 1.352-2.704 0.801 0 1.202 0.901 1.202 2.704v5.409c0 0.1 0.099 0.251 0.3 0.451h2.103c0.2 0 0.3-0.15 0.3-0.451v-5.409c0-0.901 0.049-1.552 0.15-1.953 0.3-0.5 0.7-0.751 1.202-0.751 0.7 0 1.101 0.3 1.202 0.901v7.212c0 0.1 0.15 0.251 0.451 0.451h1.953c0.2 0 0.3-0.15 0.3-0.451v-6.46c0-1.601-0.15-2.652-0.451-3.155-0.601-0.7-1.352-1.052-2.253-1.052-1.403 0-2.305 0.601-2.704 1.803-0.601-1.202-1.453-1.803-2.554-1.803-1.302 0-2.204 0.601-2.704 1.803v-1.202c0-0.3-0.1-0.451-0.3-0.451h-1.953c-0.202 0-0.3 0.15-0.3 0.451v10.066c-0.001 0.1 0.099 0.251 0.3 0.451zM31.85 10.441c0-0.7-0.101-1.15-0.3-1.352-0.101-0.399-0.451-0.601-1.052-0.601-0.901 0-1.453 0.401-1.652 1.202 0 0.1-0.101 0.251-0.3 0.451l-1.953-0.3c-0.202 0-0.3-0.15-0.3-0.451 0.399-2.003 1.902-3.005 4.507-3.005 1.202 0 2.153 0.352 2.854 1.051 0.601 0.502 0.901 1.603 0.901 3.305v3.155c0 0.502 0.25 1.103 0.751 1.803 0.2 0.202 0.2 0.401 0 0.601-0.1 0.1-0.326 0.3-0.676 0.601-0.351 0.3-0.627 0.502-0.826 0.601-0.1 0.1-0.251 0.15-0.451 0.15-0.3-0.2-0.551-0.451-0.751-0.751-0.202-0.3-0.351-0.5-0.451-0.601-0.901 0.901-1.953 1.352-3.155 1.352-2.004 0-3.005-1-3.005-3.005 0-1.502 0.7-2.604 2.103-3.305 0.3-0.099 1.552-0.3 3.756-0.601v-0.301zM31.85 12.244c-2.004 0-3.005 0.701-3.005 2.103 0 0.901 0.399 1.352 1.202 1.352 0.601 0 1.052-0.3 1.352-0.901 0.3-0.399 0.451-1.101 0.451-2.103v-0.451zM40.488 18.028c-1.453 0.052-2.68 0.376-3.681 0.977-0.401 0.401-0.351 0.601 0.15 0.601 2.503-0.3 3.956-0.248 4.357 0.15 0.2 0.3-0.15 1.704-1.051 4.207 0.099 0.202 0.25 0.251 0.451 0.15 0.901-0.7 1.552-1.728 1.953-3.080 0.399-1.352 0.451-2.179 0.15-2.479-0.102-0.4-0.878-0.576-2.33-0.527zM44.019 14.798c-0.901-0.5-2.103-0.751-3.606-0.751l3.305-4.808c0.3-0.399 0.451-0.7 0.451-0.901v-1.202c0-0.3-0.1-0.451-0.3-0.451h-6.459c-0.3 0-0.451 0.15-0.451 0.451v1.352c0 0.3 0.15 0.451 0.451 0.451h3.305l-3.906 5.558c-0.1 0.202-0.15 0.552-0.15 1.052v1.352c0 0.3 0.15 0.451 0.451 0.451 2.202-1.202 4.507-1.202 6.911 0 0.3 0 0.451-0.15 0.451-0.451v-1.502c0.001-0.3-0.15-0.5-0.451-0.601zM54.385 12.244c0 1.603-0.427 2.929-1.277 3.981-0.852 1.052-1.929 1.578-3.23 1.578-1.403 0-2.504-0.549-3.305-1.652-0.803-1.101-1.202-2.453-1.202-4.056 0-1.601 0.399-2.929 1.202-3.981 0.801-1.052 1.902-1.578 3.305-1.578 1.402 0 2.503 0.552 3.305 1.653 0.801 1.104 1.202 2.456 1.202 4.056zM51.38 12.244c0-1.202-0.1-2.103-0.3-2.704-0.1-0.601-0.502-0.901-1.202-0.901-1.002 0-1.502 1.052-1.502 3.155 0 2.606 0.501 3.906 1.502 3.906 1 0 1.502-1.15 1.502-3.456zM61.146 6.535c-1.202 0-2.103 0.653-2.704 1.953v-1.502c0-0.2-0.15-0.3-0.451-0.3h-1.803c-0.202 0-0.3 0.101-0.3 0.3v10.216c0 0.1 0.099 0.251 0.3 0.451h1.953c0.3 0 0.451-0.15 0.451-0.451v-5.409c0-0.901 0.099-1.552 0.3-1.953 0.2-0.601 0.601-0.901 1.202-0.901 0.801 0 1.202 0.953 1.202 2.854v5.409c0 0.1 0.099 0.251 0.3 0.451h1.953c0.3 0 0.451-0.15 0.451-0.451v-6.31c0-1.601-0.202-2.652-0.601-3.155-0.401-0.801-1.152-1.202-2.253-1.202z"></path></svg>',
				'american-express' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M2.909 32v-17.111h2.803l0.631-1.54h1.389l0.631 1.54h5.505v-1.162l0.48 1.162h2.853l0.506-1.187v1.187h13.661v-2.5l0.253-0.026c0.227 0 0.252 0.177 0.252 0.354v2.172h7.046v-0.58c1.642 0.858 3.889 0.58 5.606 0.58l0.631-1.54h1.414l0.631 1.54h5.733v-1.464l0.858 1.464h4.596v-9.546h-4.544v1.111l-0.631-1.111h-4.672v1.111l-0.581-1.111h-6.288c-0.934 0-1.919 0.101-2.753 0.556v-0.556h-4.344v0.556c-0.505-0.454-1.187-0.556-1.843-0.556h-15.859l-1.085 2.449-1.086-2.449h-5v1.111l-0.556-1.111h-4.267l-1.97 4.52v-9.864h58.182v17.111h-3.030c-0.707 0-1.464 0.126-2.045 0.556v-0.556h-4.47c-0.631 0-1.49 0.1-1.97 0.556v-0.556h-7.98v0.556c-0.605-0.429-1.49-0.556-2.197-0.556h-5.278v0.556c-0.53-0.505-1.616-0.556-2.298-0.556h-5.909l-1.363 1.464-1.263-1.464h-8.813v9.546h8.66l1.389-1.49 1.313 1.49h5.328v-2.248h0.53c0.758 0 1.54-0.025 2.273-0.328v2.576h4.394v-2.5h0.202c0.252 0 0.303 0.026 0.303 0.303v2.197h13.358c0.733 0 1.642-0.152 2.222-0.606v0.606h4.243c0.808 0 1.667-0.076 2.399-0.429v5.773h-58.181zM20.561 13.525h-1.667v-5.354l-2.374 5.354h-1.439l-2.373-5.354v5.354h-3.334l-0.631-1.515h-3.41l-0.631 1.515h-1.768l2.929-6.843h2.424l2.778 6.49v-6.49h2.677l2.147 4.646 1.944-4.646h2.727v6.843zM8.162 10.596l-1.137-2.727-1.111 2.727h2.248zM29.727 23.020v2.298h-3.182l-2.020-2.273-2.096 2.273h-6.465v-6.843h6.565l2.020 2.248 2.071-2.248h5.227c1.541 0 2.753 0.531 2.753 2.248 0 2.752-3.005 2.298-4.874 2.298zM23.464 21.883l-1.768-1.995h-4.116v1.238h3.586v1.389h-3.586v1.364h4.015l1.868-1.995zM27.252 13.525h-5.48v-6.843h5.48v1.439h-3.839v1.238h3.738v1.389h-3.738v1.364h3.839v1.414zM28.086 24.687v-5.48l-2.5 2.702 2.5 2.778zM33.793 10.369c0.934 0.328 1.086 0.909 1.086 1.818v1.339h-1.642c-0.026-1.464 0.353-2.475-1.464-2.475h-1.768v2.475h-1.616v-6.844l3.864 0.026c1.313 0 2.701 0.202 2.701 1.818 0 0.783-0.429 1.54-1.162 1.843zM31.848 19.889h-2.121v1.743h2.096c0.581 0 1.035-0.278 1.035-0.909 0-0.606-0.454-0.833-1.010-0.833zM32.075 8.121h-2.070v1.516h2.045c0.556 0 1.086-0.126 1.086-0.783 0-0.632-0.556-0.733-1.061-0.733zM40.788 22.136c0.909 0.328 1.086 0.934 1.086 1.818v1.364h-1.642v-1.137c0-1.162-0.379-1.364-1.464-1.364h-1.743v2.5h-1.642v-6.843h3.889c1.288 0 2.677 0.228 2.677 1.844 0 0.757-0.404 1.515-1.162 1.818zM37.555 13.525h-1.667v-6.843h1.667v6.843zM39.096 19.889h-2.071v1.541h2.045c0.556 0 1.085-0.126 1.085-0.808 0-0.631-0.555-0.732-1.060-0.732zM56.924 13.525h-2.323l-3.081-5.126v5.126h-3.334l-0.657-1.515h-3.384l-0.631 1.515h-1.894c-2.248 0-3.258-1.162-3.258-3.359 0-2.298 1.035-3.485 3.359-3.485h1.591v1.491c-1.717-0.026-3.283-0.404-3.283 1.944 0 1.162 0.278 1.97 1.591 1.97h0.732l2.323-5.379h2.45l2.753 6.465v-6.465h2.5l2.879 4.747v-4.747h1.667v6.818zM48.313 25.318h-5.455v-6.843h5.455v1.414h-3.813v1.238h3.738v1.389h-3.738v1.364l3.813 0.025v1.414zM46.975 10.596l-1.111-2.727-1.137 2.727h2.248zM52.48 25.318h-3.182v-1.464h3.182c0.404 0 0.858-0.101 0.858-0.631 0-1.464-4.217 0.556-4.217-2.702 0-1.389 1.060-2.045 2.323-2.045h3.283v1.439h-3.005c-0.429 0-0.909 0.076-0.909 0.631 0 1.49 4.243-0.682 4.243 2.601 0.001 1.615-1.111 2.172-2.575 2.172zM61.091 24.434c-0.48 0.707-1.414 0.884-2.222 0.884h-3.157v-1.464h3.157c0.404 0 0.833-0.126 0.833-0.631 0-1.439-4.217 0.556-4.217-2.702 0-1.389 1.086-2.045 2.349-2.045h3.258v1.439h-2.98c-0.454 0-0.909 0.076-0.909 0.631 0 1.212 2.854-0.025 3.889 1.338v2.55z"></path></svg>',
				'apple-pay'        => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M16.398 13.428c0.034 3.535 3.201 4.71 3.236 4.726-0.027 0.083-0.506 1.676-1.668 3.322-1.005 1.423-2.048 2.84-3.692 2.87-1.615 0.029-2.134-0.927-3.98-0.927s-2.422 0.898-3.951 0.956c-1.586 0.058-2.794-1.539-3.807-2.956-2.070-2.9-3.653-8.194-1.528-11.768 1.055-1.775 2.942-2.899 4.989-2.927 1.558-0.029 3.027 1.015 3.98 1.015s2.738-1.255 4.616-1.071c0.786 0.032 2.993 0.308 4.41 2.317-0.114 0.068-2.633 1.489-2.605 4.444zM13.363 4.749c0.842-0.987 1.409-2.362 1.254-3.729-1.213 0.047-2.682 0.783-3.552 1.77-0.78 0.874-1.464 2.273-1.279 3.613 1.353 0.101 2.735-0.666 3.577-1.654zM25.55 3.058c0.624-0.105 1.313-0.2 2.065-0.284s1.581-0.126 2.485-0.126c1.291 0 2.404 0.152 3.339 0.457s1.704 0.741 2.307 1.308c0.517 0.504 0.92 1.103 1.21 1.796s0.435 1.492 0.435 2.395c0 1.092-0.199 2.049-0.596 2.868s-0.941 1.507-1.629 2.064c-0.688 0.557-1.506 0.972-2.452 1.245s-1.979 0.41-3.098 0.41c-1.011 0-1.86-0.073-2.548-0.22v9.076h-1.517v-20.989zM27.068 13.648c0.366 0.104 0.774 0.178 1.226 0.22s0.935 0.063 1.451 0.063c1.936 0 3.436-0.441 4.501-1.323s1.597-2.174 1.597-3.876c0-0.819-0.14-1.534-0.42-2.143s-0.677-1.108-1.193-1.497c-0.516-0.388-1.129-0.683-1.839-0.882s-1.495-0.3-2.356-0.3c-0.688 0-1.28 0.027-1.774 0.079s-0.893 0.11-1.193 0.173l0.001 9.487zM49.452 20.454c0 0.61 0.010 1.219 0.032 1.828s0.086 1.197 0.194 1.765h-1.42l-0.225-2.143h-0.065c-0.194 0.294-0.441 0.588-0.742 0.882s-0.65 0.562-1.048 0.803c-0.398 0.242-0.85 0.436-1.355 0.583s-1.059 0.22-1.662 0.22c-0.753 0-1.414-0.121-1.985-0.362s-1.038-0.557-1.403-0.946c-0.366-0.389-0.64-0.836-0.822-1.339s-0.274-1.008-0.274-1.513c0-1.786 0.769-3.162 2.307-4.129s3.855-1.429 6.953-1.387v-0.41c0-0.399-0.038-0.856-0.113-1.371s-0.242-1.003-0.5-1.465c-0.258-0.462-0.645-0.851-1.161-1.166s-1.215-0.473-2.097-0.473c-0.666 0-1.328 0.1-1.983 0.299s-1.253 0.478-1.791 0.835l-0.484-1.103c0.688-0.462 1.399-0.793 2.13-0.992s1.495-0.3 2.29-0.3c1.076 0 1.952 0.178 2.63 0.536s1.21 0.819 1.597 1.387c0.387 0.567 0.651 1.202 0.791 1.906s0.21 1.402 0.21 2.096l-0.001 5.957zM47.936 15.948c-0.818-0.021-1.673 0.010-2.566 0.094s-1.715 0.268-2.468 0.552c-0.753 0.284-1.377 0.699-1.871 1.245s-0.742 1.271-0.742 2.175c0 1.072 0.312 1.859 0.935 2.364s1.323 0.757 2.097 0.757c0.624 0 1.182-0.084 1.677-0.252s0.925-0.394 1.291-0.677c0.366-0.283 0.672-0.603 0.919-0.961s0.436-0.725 0.565-1.103c0.108-0.421 0.161-0.726 0.161-0.915l0.001-3.277zM52.418 8.919l3.935 9.833c0.215 0.547 0.42 1.108 0.613 1.686s0.366 1.108 0.516 1.591h0.065c0.15-0.462 0.322-0.982 0.516-1.56s0.409-1.171 0.645-1.781l3.679-9.77h1.613l-4.484 11.094c-0.452 1.177-0.877 2.243-1.275 3.199s-0.801 1.817-1.21 2.585c-0.409 0.767-0.822 1.445-1.242 2.033s-0.887 1.103-1.404 1.544c-0.602 0.525-1.156 0.908-1.661 1.151s-0.844 0.394-1.016 0.457l-0.517-1.229c0.387-0.168 0.818-0.388 1.291-0.662s0.936-0.63 1.387-1.072c0.387-0.378 0.812-0.877 1.274-1.497s0.876-1.371 1.242-2.254c0.13-0.336 0.194-0.557 0.194-0.662 0-0.147-0.065-0.367-0.194-0.662l-5.582-14.025h1.614z"></path></svg>',
				'bank-transfer'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M8.498 23.915h-1.588l1.322-5.127h-1.832l0.286-1.099h5.259l-0.287 1.099h-1.837l-1.323 5.127zM13.935 21.526l-0.62 2.389h-1.588l1.608-6.226h1.869c0.822 0 1.44 0.145 1.853 0.435 0.412 0.289 0.62 0.714 0.62 1.273 0 0.449-0.145 0.834-0.432 1.156-0.289 0.322-0.703 0.561-1.245 0.717l1.359 2.645h-1.729l-1.077-2.389h-0.619zM14.21 20.452h0.406c0.454 0 0.809-0.081 1.062-0.243s0.38-0.409 0.38-0.741c0-0.233-0.083-0.407-0.248-0.523s-0.424-0.175-0.778-0.175h-0.385l-0.438 1.682zM22.593 22.433h-2.462l-0.895 1.482h-1.666l3.987-6.252h1.942l0.765 6.252h-1.546l-0.125-1.482zM22.515 21.326l-0.134-1.491c-0.035-0.372-0.052-0.731-0.052-1.077v-0.154c-0.153 0.34-0.342 0.701-0.567 1.081l-0.979 1.64h1.732zM31.663 23.915h-1.78l-1.853-4.71h-0.032l-0.021 0.136c-0.111 0.613-0.226 1.161-0.343 1.643l-0.755 2.93h-1.432l1.608-6.226h1.859l1.77 4.586h0.021c0.042-0.215 0.109-0.524 0.204-0.924s0.406-1.621 0.937-3.662h1.427l-1.609 6.225zM38.412 22.075c0 0.593-0.257 1.062-0.771 1.407s-1.21 0.517-2.088 0.517c-0.768 0-1.386-0.128-1.853-0.383v-1.167c0.669 0.307 1.291 0.46 1.863 0.46 0.389 0 0.693-0.060 0.911-0.181s0.328-0.285 0.328-0.495c0-0.122-0.024-0.229-0.071-0.322s-0.114-0.178-0.2-0.257c-0.088-0.079-0.303-0.224-0.646-0.435-0.479-0.28-0.817-0.559-1.011-0.835-0.195-0.275-0.292-0.572-0.292-0.89 0-0.366 0.108-0.693 0.323-0.982 0.214-0.288 0.522-0.512 0.918-0.673 0.398-0.16 0.854-0.24 1.372-0.24 0.753 0 1.442 0.14 2.067 0.421l-0.567 0.993c-0.541-0.21-1.041-0.316-1.499-0.316-0.289 0-0.525 0.064-0.708 0.192-0.185 0.128-0.276 0.297-0.276 0.506 0 0.173 0.057 0.325 0.172 0.454 0.114 0.129 0.371 0.3 0.771 0.513 0.419 0.227 0.733 0.477 0.942 0.752 0.21 0.273 0.314 0.593 0.314 0.959zM41.266 23.915h-1.588l1.608-6.226h4.238l-0.281 1.082h-2.645l-0.412 1.606h2.463l-0.292 1.077h-2.463l-0.63 2.461zM49.857 23.915h-4.253l1.608-6.226h4.259l-0.281 1.082h-2.666l-0.349 1.367h2.484l-0.286 1.081h-2.484l-0.417 1.606h2.666l-0.28 1.091zM53.857 21.526l-0.62 2.389h-1.588l1.608-6.226h1.869c0.822 0 1.44 0.145 1.853 0.435s0.62 0.714 0.62 1.273c0 0.449-0.145 0.834-0.432 1.156-0.289 0.322-0.703 0.561-1.245 0.717l1.359 2.645h-1.729l-1.077-2.389h-0.619zM54.133 20.452h0.406c0.454 0 0.809-0.081 1.062-0.243s0.38-0.409 0.38-0.741c0-0.233-0.083-0.407-0.248-0.523s-0.424-0.175-0.778-0.175h-0.385l-0.438 1.682zM30.072 8.026c0.796 0 1.397 0.118 1.804 0.355s0.61 0.591 0.61 1.061c0 0.436-0.144 0.796-0.433 1.080-0.289 0.283-0.699 0.472-1.231 0.564v0.026c0.348 0.076 0.625 0.216 0.831 0.421 0.207 0.205 0.31 0.467 0.31 0.787 0 0.666-0.266 1.179-0.797 1.539s-1.267 0.541-2.206 0.541h-2.72l1.611-6.374h2.221zM28.111 13.284h0.938c0.406 0 0.726-0.084 0.957-0.253s0.347-0.403 0.347-0.701c0-0.471-0.317-0.707-0.954-0.707h-0.86l-0.428 1.661zM28.805 10.55h0.776c0.421 0 0.736-0.071 0.946-0.212s0.316-0.344 0.316-0.608c0-0.398-0.296-0.598-0.886-0.598h-0.792l-0.36 1.418zM37.242 12.883h-2.466l-0.897 1.517h-1.669l3.993-6.4h1.945l0.766 6.4h-1.548l-0.125-1.517zM37.163 11.749l-0.135-1.526c-0.035-0.381-0.053-0.748-0.053-1.103v-0.157c-0.153 0.349-0.342 0.718-0.568 1.107l-0.98 1.679h1.736zM46.325 14.4h-1.782l-1.856-4.822h-0.032l-0.021 0.14c-0.111 0.628-0.226 1.188-0.344 1.683l-0.756 3h-1.434l1.611-6.374h1.861l1.773 4.695h0.021c0.042-0.22 0.11-0.536 0.203-0.946s0.406-1.66 0.938-3.749h1.428l-1.611 6.374zM54.1 14.4h-1.763l-1.099-2.581-0.652 0.305-0.568 2.276h-1.59l1.611-6.374h1.596l-0.792 3.061 0.824-0.894 2.132-2.166h1.882l-3.097 3.052 1.517 3.322zM23.040 8.64c0-0.353-0.287-0.64-0.64-0.64h-14.080c-0.353 0-0.64 0.287-0.64 0.64v0c0 0.353 0.287 0.64 0.64 0.64h14.080c0.353 0 0.64-0.287 0.64-0.64v0zM19.2 11.2c0-0.353-0.287-0.64-0.64-0.64h-10.24c-0.353 0-0.64 0.287-0.64 0.64v0c0 0.353 0.287 0.64 0.64 0.64h10.24c0.353 0 0.64-0.287 0.64-0.64v0zM15.36 13.76c0-0.353-0.287-0.64-0.64-0.64h-6.4c-0.353 0-0.64 0.287-0.64 0.64v0c0 0.353 0.287 0.64 0.64 0.64h6.4c0.353 0 0.64-0.287 0.64-0.64v0z"></path></svg>',
				'google-pay'       => '<svg viewBox="0 0 436 174" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0)"><path d="M206.2 84.58v50.75h-16.1V10h42.7a38.61 38.61 0 0 1 27.65 10.85A34.88 34.88 0 0 1 272 47.3a34.713 34.713 0 0 1-11.55 26.6c-7.467 7.12-16.683 10.677-27.65 10.67h-26.6v.01zm0-59.15v43.75h27a21.282 21.282 0 0 0 15.93-6.48 21.349 21.349 0 0 0 4.786-23.628 21.346 21.346 0 0 0-4.786-7.002 21 21 0 0 0-15.93-6.65h-27v.01zm102.9 21.35c11.9 0 21.293 3.18 28.18 9.54 6.887 6.36 10.327 15.08 10.32 26.16v52.85h-15.4v-11.9h-.7c-6.667 9.8-15.533 14.7-26.6 14.7-9.447 0-17.35-2.8-23.71-8.4a26.827 26.827 0 0 1-9.54-21c0-8.873 3.353-15.93 10.06-21.17 6.707-5.24 15.66-7.867 26.86-7.88 9.56 0 17.433 1.75 23.62 5.25v-3.68A18.337 18.337 0 0 0 325.54 67 22.8 22.8 0 0 0 310 61.13c-8.993 0-16.11 3.793-21.35 11.38l-14.18-8.93c7.8-11.2 19.343-16.8 34.63-16.8zm-20.83 62.3a12.853 12.853 0 0 0 5.34 10.5 19.638 19.638 0 0 0 12.51 4.2 25.67 25.67 0 0 0 18.11-7.52c5.333-5.02 8-10.91 8-17.67-5.02-4-12.02-6-21-6-6.54 0-11.993 1.577-16.36 4.73-4.41 3.2-6.6 7.09-6.6 11.76zM436 49.58l-53.76 123.55h-16.62l19.95-43.23-35.35-80.32h17.5l25.55 61.6h.35l24.85-61.6H436z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M72 28.5a39.09 39.09 0 0 1 27.62 10.8l20.55-20.55A69.18 69.18 0 0 0 72 0a72 72 0 0 0 0 144c19.43 0 35.79-6.38 47.72-17.38l-.013-.01h.013c13.59-12.53 21.42-31.06 21.42-52.97A85.82 85.82 0 0 0 139.9 59H72v27.73h38.89a33.323 33.323 0 0 1-14.38 21.88v.01C90.05 113 81.73 115.5 72 115.5c-18.78 0-34.72-12.66-40.42-29.72a43.14 43.14 0 0 1 0-27.56C37.28 41.16 53.22 28.5 72 28.5z"/></g><defs><clipPath id="clip0"><path d="M0 0h435.97v173.13H0z"/></clipPath></defs></svg>',
				'google-wallet'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M20 28.188h1.242l-0.276 0.276v0.966l-0.69 0.138c-0.186 0-0.368 0.024-0.552 0.069-0.186 0.047-0.323 0.069-0.414 0.069-0.737 0-1.289-0.229-1.655-0.69-0.368-0.46-0.552-0.918-0.552-1.379 0-1.379 0.78-2.069 2.345-2.069 0.366 0 0.642 0.047 0.828 0.138 0.276 0 0.504 0.092 0.69 0.276l-0.552 0.552 0.138-0.276c-0.737-0.366-1.151-0.552-1.242-0.552-1.013 0-1.517 0.552-1.517 1.655 0 1.379 0.642 2.069 1.931 2.069 0.366 0 0.597-0.045 0.69-0.138v-0.966l-0.828 0.138 0.415-0.278zM19.034 6.118c0.366-0.827 1.011-1.242 1.931-1.242 0.276 0 0.597 0.092 0.966 0.276 2.021 1.013 3.814 2.531 5.379 4.552v1.242c0 1.931-0.506 3.771-1.517 5.517 0 0.092-0.047 0.138-0.138 0.138-0.186 0.552-0.23 0.966-0.138 1.242-0.276-4.045-2.161-6.987-5.655-8.828-1.288-0.735-1.564-1.701-0.827-2.897zM22.897 26.67c-1.013 0-1.517 0.506-1.517 1.517 0 0.92 0.504 1.379 1.517 1.379 1.011 0 1.517-0.46 1.517-1.379 0-1.011-0.506-1.517-1.517-1.517zM23.586 29.153c-0.186 0.186-0.368 0.276-0.552 0.276-0.737 0-1.103-0.552-1.103-1.655 0-0.090 0.090-0.321 0.276-0.69 0.090-0.090 0.276-0.138 0.552-0.138 0.735 0 1.103 0.506 1.103 1.517 0 0.093-0.092 0.324-0.276 0.69zM26.207 26.67c-1.103 0-1.655 0.506-1.655 1.517 0 0.92 0.504 1.379 1.517 1.379 1.011 0 1.517-0.46 1.517-1.379-0.001-1.011-0.461-1.517-1.38-1.517zM26.758 29.153c-0.186 0.186-0.368 0.276-0.552 0.276-0.644 0-0.966-0.552-0.966-1.655 0-0.276 0.090-0.504 0.276-0.69 0.090-0.090 0.229-0.138 0.414-0.138 0.735 0 1.103 0.506 1.103 1.517 0 0.093-0.092 0.324-0.276 0.69zM26.069 5.567c-0.276-0.827-0.323-1.517-0.138-2.069 0.184-0.366 0.366-0.642 0.552-0.828 0.184-0.184 0.46-0.366 0.828-0.552 0.090 0 0.207-0.021 0.345-0.069 0.138-0.045 0.297-0.069 0.483-0.069 0.366 0 0.78 0.138 1.242 0.414 0.276 0.092 0.46 0.276 0.552 0.552 0.090 0 0.138 0.047 0.138 0.138 1.469 2.392 2.207 5.058 2.207 8v0.966c-0.092 2.392-0.828 4.69-2.207 6.897-0.461 0.737-1.103 1.103-1.931 1.103h-0.69c-0.092 0-0.186-0.045-0.276-0.138-0.092-0.090-0.186-0.138-0.276-0.138-0.552-0.366-0.92-0.966-1.103-1.793 0-0.552 0.090-0.966 0.276-1.242v-0.137c1.103-1.655 1.655-3.494 1.655-5.517 0-0.090-0.024-0.276-0.069-0.552-0.047-0.276-0.069-0.504-0.069-0.69-0.185-1.562-0.689-2.987-1.517-4.276zM30.483 26.808h-1.242c-0.461 0-0.782 0.092-0.966 0.276-0.276 0.276-0.414 0.552-0.414 0.828 0 0.644 0.321 0.966 0.966 0.966h0.138v0.276c0.090 0.186 0.138 0.323 0.138 0.414-0.461 0-0.828 0.092-1.103 0.276-0.276 0.092-0.414 0.323-0.414 0.69 0 0.552 0.414 0.828 1.242 0.828 1.011 0 1.517-0.366 1.517-1.103 0-0.366-0.138-0.642-0.414-0.828l-0.276-0.138c0-0.090-0.024-0.138-0.069-0.138-0.047 0-0.069-0.045-0.069-0.138 0-0.090 0.045-0.184 0.138-0.276 0.366-0.366 0.552-0.69 0.552-0.966s-0.138-0.552-0.414-0.828h0.276l0.414-0.138zM29.931 30.532c0 0.368-0.276 0.552-0.828 0.552-0.737 0-1.103-0.229-1.103-0.69 0-0.090 0.184-0.321 0.552-0.69h0.828c0.365 0.276 0.551 0.552 0.551 0.828zM29.517 28.602c-0.186 0.092-0.323 0.138-0.414 0.138-0.461 0-0.69-0.366-0.69-1.103 0-0.184 0.045-0.321 0.138-0.414 0-0.184 0.138-0.276 0.414-0.276 0.46 0 0.69 0.368 0.69 1.103-0.001 0.276-0.048 0.461-0.138 0.552zM36.483 9.774c0.045 0.506 0.069 0.944 0.069 1.31 0 2.944-0.599 5.655-1.793 8.138l-0.138 0.138c0 0.092-0.024 0.23-0.069 0.414-0.047 0.186-0.069 0.323-0.069 0.414v-0.829c0-2.758-0.599-5.194-1.793-7.31v-0.966c0-2.942-0.737-5.608-2.207-8l-0.138-0.138c-0.092-0.184-0.23-0.366-0.414-0.552h-0.138c2.758 1.655 4.966 3.816 6.621 6.483 0.002 0.093 0.023 0.393 0.070 0.897zM31.448 29.015v-3.448l0.276-0.276h-0.828l-0.414 0.138h0.414v3.725l-0.138 0.138c-0.092 0.092-0.138 0.186-0.138 0.276h1.103l0.276-0.139c-0.186 0-0.323-0.045-0.414-0.138-0.092 0-0.138-0.090-0.138-0.276zM32.414 28.050h0.414l1.517-0.552-0.138-0.138c-0.092-0.184-0.186-0.321-0.276-0.414-0.368-0.184-0.599-0.276-0.69-0.276-0.92 0-1.379 0.461-1.379 1.379 0 0.552 0.228 1.013 0.69 1.379 0.184 0.092 0.414 0.138 0.69 0.138s0.504-0.045 0.69-0.138h0.138l0.276-0.414c-0.186 0.186-0.414 0.276-0.69 0.276-0.739 0.001-1.152-0.413-1.242-1.24zM32.414 27.774c0-0.552 0.228-0.828 0.69-0.828 0.366 0 0.552 0.186 0.552 0.552l-0.138 0.138-1.103 0.414v-0.276zM41.793 11.084c0 2.024-0.186 3.816-0.552 5.379-0.186 0.552-0.323 1.013-0.414 1.379-0.368 1.196-0.828 2.392-1.379 3.586-0.368 0.828-1.103 1.242-2.207 1.242-0.461 0-0.782-0.045-0.966-0.138-0.828-0.46-1.289-1.011-1.379-1.655v-0.69c0-0.276 0.045-0.597 0.138-0.966 1.287-2.758 1.931-5.469 1.931-8.138 0-2.758-0.644-5.517-1.931-8.276-0.644-1.469-0.23-2.528 1.242-3.172 0.365-0.182 0.689-0.275 0.965-0.275 1.011 0 1.745 0.461 2.207 1.379 0.642 1.289 1.242 2.944 1.793 4.966 0.366 1.471 0.552 3.265 0.552 5.379zM38.483 26.808h0.276l-0.552 2.758h-0.414l-0.552-2.483-0.552 2.483h-0.414l-0.69-2.758h0.276l0.552 2.483 0.552-2.483h0.414l0.552 2.483 0.552-2.483zM41.103 27.636c0-0.642-0.323-0.966-0.966-0.966-0.461 0-0.782 0.276-0.966 0.828h0.276c0.184-0.276 0.414-0.414 0.69-0.414 0.366 0 0.552 0.186 0.552 0.552v0.276l-0.138-0.138c-0.186 0-0.323 0-0.414 0-0.644 0-0.966 0.276-0.966 0.828 0 0.644 0.276 0.966 0.828 0.966 0.459 0 0.69-0.090 0.69-0.276l0.138 0.276h0.276v-1.93zM40.69 28.877c0 0.276-0.23 0.414-0.69 0.414-0.368 0-0.552-0.229-0.552-0.69 0-0.366 0.228-0.552 0.69-0.552 0.090 0 0.228 0 0.414 0l0.138 0.138v0.689zM41.655 25.705h0.276v3.862h-0.276v-3.862zM42.621 25.705h0.276v3.862h-0.276v-3.862zM44.414 26.67c-0.644 0-0.966 0.506-0.966 1.517 0 0.92 0.321 1.379 0.966 1.379 0.642 0 0.966-0.321 0.966-0.966h-0.276c0 0.461-0.23 0.69-0.69 0.69-0.461 0-0.69-0.366-0.69-1.103h1.655v-0.138c0-0.918-0.323-1.379-0.965-1.379zM43.724 27.912c0.090-0.552 0.321-0.828 0.69-0.828 0.459 0 0.69 0.276 0.69 0.828h-1.38zM46.345 26.808h0.552v0.276h-0.552v1.793c0 0.276 0.090 0.414 0.276 0.414l0.276-0.138v0.276c-0.092 0.092-0.23 0.138-0.414 0.138-0.368 0-0.552-0.184-0.552-0.552v-1.931h-0.276v-0.276h0.276v-0.828l0.414-0.138v0.965z"></path></svg>',
				'maestro'          => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M42.667-0c-4.099 0-7.836 1.543-10.667 4.077-2.831-2.534-6.568-4.077-10.667-4.077-8.836 0-16 7.163-16 16s7.164 16 16 16c4.099 0 7.835-1.543 10.667-4.077 2.831 2.534 6.568 4.077 10.667 4.077 8.837 0 16-7.163 16-16s-7.163-16-16-16zM16.73 20.027l1.215-6.381-2.887 6.381h-1.823l-0.304-6.381-1.215 6.381h-1.823l1.519-8.357h3.191l0.152 5.166 2.279-5.166h3.343l-1.672 8.357h-1.974zM25.998 16.38l-0.456 2.431v0.456l-0.152 0.304v0.456h-1.672v-0.76c-0.406 0.608-1.116 0.911-2.127 0.911-1.215 0-1.823-0.658-1.823-1.975 0-1.722 1.163-2.583 3.495-2.583 0.403 0 0.707 0.052 0.911 0.152v-0.456c0-0.403-0.406-0.608-1.215-0.608-0.911 0-1.469 0.052-1.672 0.152h-0.304l-0.152 0.152 0.152-1.519c1.011-0.304 1.823-0.456 2.431-0.456 1.823 0 2.735 0.66 2.735 1.975 0 0.406-0.052 0.862-0.152 1.368zM32.076 19.875c-0.812 0.204-1.469 0.304-1.975 0.304-2.332 0-3.495-1.011-3.495-3.039 0-2.735 1.163-4.102 3.495-4.102 1.823 0 2.735 0.812 2.735 2.431 0 0.71-0.053 1.268-0.152 1.672h-4.102v0.304c0 0.812 0.556 1.215 1.672 1.215 0.81 0 1.519-0.152 2.127-0.456l-0.305 1.67zM38.154 14.708h-1.519c-0.608 0-0.911 0.152-0.911 0.456s0.304 0.557 0.911 0.76c0.911 0.406 1.368 1.064 1.368 1.975 0 1.519-1.064 2.279-3.191 2.279h-0.456c-0.204-0.099-0.406-0.152-0.608-0.152h-0.608l-0.304-0.152h-0.152l0.304-1.519c1.011 0.204 1.619 0.304 1.823 0.304 0.81 0 1.215-0.202 1.215-0.608 0-0.304-0.304-0.556-0.911-0.76-1.116-0.506-1.672-1.163-1.672-1.975 0-1.519 1.064-2.279 3.191-2.279 0.1 0 0.38 0.026 0.836 0.076 0.456 0.053 0.783 0.076 0.988 0.076l-0.304 1.519zM41.649 19.875c-0.812 0.204-1.317 0.304-1.519 0.304-1.014 0-1.519-0.506-1.519-1.519v-0.608l0.152-0.608v-0.608l1.064-5.166h1.975l-0.304 1.519h1.064l-0.304 1.672h-1.064l-0.456 2.887c-0.102 0.102-0.152 0.204-0.152 0.304 0 0.304 0.252 0.456 0.76 0.456 0.304 0 0.506-0.050 0.608-0.152l-0.304 1.519zM44.383 20.027h-2.127l1.215-6.838h1.975l-0.304 1.064c0.608-0.707 1.215-1.064 1.823-1.064h0.456l0.152 0.152-0.76 1.823h-0.456c-0.709 0-1.366 1.621-1.974 4.863zM53.956 16.987c-0.304 2.127-1.621 3.191-3.951 3.191-2.229 0-3.343-1.064-3.343-3.191 0-1.114 0.38-2.051 1.14-2.811s1.747-1.14 2.963-1.14c2.127 0 3.191 1.014 3.191 3.039v0.912zM21.743 18.051c0 0.406 0.252 0.608 0.76 0.608 0.911 0 1.368-0.556 1.368-1.672h-0.456c-1.116 0-1.672 0.357-1.672 1.064zM31.012 15.468c0-0.608-0.304-0.912-0.911-0.912-0.71 0-1.165 0.406-1.368 1.215h2.279v-0.303zM50.765 14.708c-1.116 0-1.672 0.76-1.672 2.279 0 1.014 0.354 1.519 1.064 1.519 0.81 0 1.368-0.556 1.672-1.672v-0.76c0-0.911-0.356-1.367-1.064-1.367z"></path></svg>',
				'pay-u'            => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M14.084 9.060c-0.722-0.708-1.882-1.068-3.45-1.068h-6.097c-1.565 0-2.726 0.36-3.448 1.068-0.721 0.707-1.089 1.899-1.089 3.216v11.731h2.845v-6.515h7.79c1.567 0 2.73-0.358 3.45-1.067 0.722-0.707 1.089-1.898 1.089-3.542v-0.28c0-1.642-0.367-2.835-1.089-3.541zM12.33 12.992c0 1.049-0.413 1.516-1.34 1.516h-8.145v-2.014c0-1.048 0.412-1.515 1.341-1.515h6.805c0.926 0 1.34 0.467 1.34 1.515v0.498zM29.213 9.061c-0.721-0.709-1.884-1.068-3.45-1.068h-8.124v2.985h8.478c0.929 0 1.34 0.467 1.34 1.515v2.013h-7.789c-1.568 0-2.729 0.36-3.451 1.069-0.72 0.707-1.089 1.899-1.089 3.541v0.282c0 1.642 0.369 2.835 1.089 3.541 0.722 0.708 1.884 1.068 3.451 1.068h6.095c1.565 0 2.728-0.36 3.45-1.068 0.721-0.706 1.089-1.899 1.089-3.215v-6.795c0.001-1.969-0.367-3.161-1.088-3.867zM27.457 19.507c0 1.050-0.411 1.515-1.34 1.515l-6.805 0.002c-0.929 0-1.341-0.467-1.341-1.516v-0.5c0-1.048 0.411-1.515 1.341-1.515h8.145v2.014zM47.032 7.993v11.080c0 1.642-0.369 3.161-1.088 3.866-0.722 0.709-1.884 1.068-3.45 1.068h-8.123v-2.985h8.478c0.928 0 1.34-0.467 1.34-1.515v-2.014h-7.789c-1.567 0-2.73-0.357-3.452-1.066-0.72-0.707-1.087-1.899-1.087-3.542v-4.891h2.842v5c0 1.049 0.412 1.516 1.34 1.516h8.146v-6.516h2.844zM64 7.993v11.405c0 1.642-0.368 2.835-1.088 3.541-0.722 0.708-1.885 1.068-3.45 1.068h-6.095c-1.567 0-2.73-0.36-3.451-1.068-0.721-0.706-1.088-1.899-1.088-3.541v-11.405h2.842v11.514c0 1.050 0.412 1.515 1.341 1.515h6.805c0.928 0 1.341-0.465 1.341-1.515v-11.514h2.843z"></path></svg>',
				'western-union'    => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 64 32"><path d="M32 27.099c-10.36 0-20.721 0-31.082 0-0.278 0-0.278 0-0.278-0.273 0-7.221 0-14.442 0-21.663 0-0.264 0-0.264 0.269-0.264 20.727 0 41.454 0 62.181 0 0.269 0 0.269 0 0.269 0.264 0 7.227 0 14.454-0.001 21.681 0 0.295 0.040 0.255-0.259 0.255-10.366 0.001-20.733 0.001-31.099 0.001zM6.005 7.949c0.019 0.002 0.037 0.004 0.056 0.006 0.047 0.319 0.097 0.637 0.142 0.956 0.054 0.38 0.103 0.76 0.156 1.139 0.043 0.302 0.090 0.604 0.134 0.906 0.038 0.255 0.074 0.51 0.114 0.764 0.021 0.128 0.024 0.129 0.163 0.13 0.21 0.001 0.42 0.001 0.63 0.001 0.552 0 1.105 0.001 1.656-0.001 0.147 0 0.147-0.003 0.178-0.141 0.038-0.169 0.078-0.338 0.115-0.508 0.119-0.557 0.235-1.114 0.355-1.67 0.097-0.451 0.198-0.9 0.296-1.351 0.090-0.416 0.179-0.832 0.268-1.249 0.075-0.351 0.151-0.703 0.228-1.053 0.015-0.071-0.008-0.097-0.081-0.097-0.63 0.001-1.26 0.002-1.891 0-0.086 0-0.127 0.026-0.137 0.12-0.032 0.292-0.074 0.582-0.113 0.874-0.103 0.76-0.205 1.52-0.31 2.28-0.024 0.173-0.061 0.343-0.097 0.54-0.027-0.040-0.042-0.052-0.045-0.067-0.063-0.378-0.128-0.755-0.184-1.133-0.093-0.622-0.18-1.245-0.27-1.867-0.031-0.214-0.070-0.426-0.096-0.64-0.010-0.086-0.044-0.116-0.125-0.106-0.024 0.003-0.048 0-0.072 0-0.69 0-1.381 0-2.070 0.001-0.042 0-0.087-0.008-0.125 0.005-0.034 0.011-0.070 0.040-0.086 0.070-0.020 0.035-0.019 0.081-0.025 0.122-0.040 0.285-0.079 0.57-0.121 0.854-0.053 0.355-0.113 0.71-0.166 1.065-0.067 0.45-0.127 0.901-0.195 1.352-0.017 0.116-0.051 0.229-0.077 0.343-0.054-0.141-0.088-0.28-0.107-0.42-0.060-0.427-0.113-0.855-0.17-1.282-0.088-0.659-0.179-1.318-0.267-1.976-0.017-0.128-0.014-0.131-0.15-0.131-0.612-0.001-1.224-0.001-1.837-0.001-0.132 0-0.137 0.004-0.111 0.129 0.084 0.411 0.169 0.821 0.259 1.231 0.111 0.509 0.228 1.017 0.339 1.526 0.087 0.397 0.168 0.796 0.254 1.194 0.054 0.252 0.115 0.502 0.169 0.754 0.081 0.381 0.159 0.762 0.236 1.144 0.013 0.063 0.042 0.096 0.109 0.091 0.030-0.002 0.060 0 0.090 0 0.739 0 1.476 0 2.215 0 0.036 0 0.076 0.008 0.107-0.003 0.034-0.012 0.070-0.038 0.088-0.069 0.020-0.035 0.023-0.080 0.029-0.122 0.081-0.593 0.161-1.187 0.243-1.78 0.068-0.486 0.138-0.972 0.211-1.458 0.023-0.159 0.059-0.315 0.090-0.472zM30.034 16.759c-0.015 0.001-0.030 0.003-0.045 0.004-0.052-0.125-0.108-0.25-0.154-0.377-0.117-0.327-0.229-0.655-0.343-0.983-0.251-0.717-0.502-1.434-0.753-2.15-0.046-0.131-0.051-0.14-0.19-0.141-0.864-0.001-1.728-0.001-2.592 0-0.123 0-0.126 0.003-0.127 0.135-0.002 0.234-0.001 0.468-0.001 0.702 0 1.68 0 3.36 0 5.040 0 0.172 0.001 0.174 0.165 0.174 0.534 0.001 1.068 0.001 1.602-0.001 0.138 0 0.138-0.003 0.142-0.139 0.001-0.018 0.001-0.036 0.001-0.054 0-1.044-0.001-2.088 0.001-3.132 0-0.117 0.017-0.234 0.027-0.351 0.074 0.097 0.124 0.197 0.163 0.302 0.126 0.348 0.248 0.698 0.37 1.048 0.247 0.712 0.493 1.425 0.739 2.138 0.065 0.189 0.065 0.189 0.264 0.189 0.816 0 1.632 0.001 2.448 0 0.237 0 0.22 0.031 0.22-0.223 0.001-1.746 0-3.492 0-5.238 0-0.15 0.003-0.3 0-0.45-0.003-0.136-0.006-0.14-0.143-0.14-0.54-0.001-1.080-0.001-1.62-0.001-0.156 0-0.158 0.003-0.158 0.16-0.001 1.062 0 2.124-0.001 3.185 0 0.1-0.008 0.201-0.013 0.302zM48.181 8.173c0.013-0.002 0.026-0.003 0.038-0.005 0.036 0.086 0.078 0.17 0.109 0.257 0.136 0.39 0.267 0.781 0.403 1.171 0.248 0.712 0.501 1.422 0.746 2.135 0.031 0.088 0.069 0.122 0.163 0.122 0.864-0.003 1.729-0.001 2.593-0.003 0.135 0 0.138-0.003 0.138-0.141 0.001-0.444 0.001-0.888 0.001-1.332 0-1.471 0-2.941-0.001-4.412 0-0.182-0.002-0.182-0.178-0.183-0.522-0.001-1.044-0.001-1.567 0-0.159 0.001-0.161 0.003-0.161 0.157-0.001 0.528-0.001 1.056-0.001 1.585 0 0.564 0.001 1.128-0.001 1.693 0 0.073 0.015 0.152-0.053 0.237-0.036-0.077-0.069-0.133-0.091-0.193-0.054-0.146-0.104-0.293-0.156-0.44-0.177-0.502-0.354-1.004-0.531-1.507-0.166-0.474-0.334-0.947-0.496-1.422-0.028-0.080-0.060-0.113-0.149-0.113-0.864 0.003-1.729 0.001-2.593 0.003-0.145 0-0.146 0.004-0.146 0.156 0 1.35 0 2.701-0.001 4.051 0 0.576-0.001 1.153 0.001 1.729 0 0.127 0.003 0.131 0.128 0.131 0.546 0.001 1.093 0.001 1.638 0 0.139 0 0.139-0.003 0.143-0.139 0.001-0.048 0.001-0.096 0.001-0.144-0.001-1.056-0.003-2.113-0.002-3.169 0.001-0.075 0.015-0.15 0.023-0.225zM48.184 15.484c0.013-0.001 0.026-0.003 0.040-0.004 0.048 0.127 0.097 0.253 0.143 0.381 0.13 0.36 0.261 0.72 0.387 1.082 0.237 0.684 0.47 1.37 0.709 2.053 0.058 0.167 0.021 0.168 0.24 0.168 0.822 0 1.644 0 2.467 0 0.036 0 0.072-0.001 0.108-0.001 0.058 0.001 0.091-0.024 0.092-0.084 0.001-0.030 0.001-0.060 0.001-0.090 0-1.902 0.001-3.804 0-5.707 0-0.168-0.002-0.17-0.169-0.17-0.516-0.001-1.032-0.001-1.548-0.001-0.207 0-0.189-0.012-0.189 0.2 0 1.020 0 2.040-0.001 3.060 0 0.090 0.002 0.18-0.003 0.27-0.002 0.035-0.020 0.069-0.030 0.104-0.067-0.080-0.106-0.159-0.136-0.243-0.093-0.259-0.184-0.52-0.276-0.78-0.129-0.366-0.259-0.733-0.387-1.1-0.164-0.469-0.327-0.938-0.488-1.408-0.027-0.078-0.062-0.109-0.154-0.109-0.852 0.006-1.704 0.004-2.556 0.004-0.182 0-0.183-0.001-0.183 0.175-0.001 1.902-0.002 3.804-0.002 5.707 0 0.168 0.001 0.17 0.17 0.17 0.522 0.001 1.044 0.001 1.566 0 0.173 0 0.173-0.001 0.175-0.18 0-0.036-0.001-0.072-0.001-0.108 0-1.038-0.001-2.076 0.001-3.114 0.002-0.092 0.017-0.184 0.025-0.276zM43.196 8.794c-0.001-0.012-0.001-0.024-0.001-0.036 0.094-0.037 0.188-0.074 0.282-0.11 0.449-0.175 0.749-0.479 0.847-0.964 0.057-0.282 0.042-0.557-0.024-0.836-0.085-0.364-0.305-0.614-0.622-0.793-0.197-0.111-0.411-0.172-0.63-0.198-0.297-0.037-0.596-0.067-0.895-0.070-0.792-0.010-1.584-0.003-2.376-0.003-0.312 0-0.624-0.001-0.936 0.001-0.12 0.001-0.12 0.005-0.125 0.12-0.001 0.030 0 0.060 0 0.090 0 1.866 0 3.732 0 5.599 0 0.048 0.003 0.096-0.001 0.144-0.006 0.084 0.026 0.116 0.114 0.115 0.696-0.003 1.392-0.001 2.088-0.002 0.12 0 0.122-0.006 0.127-0.119 0.002-0.042 0.001-0.084 0.001-0.126-0.003-0.606-0.005-1.212-0.010-1.818-0.001-0.084 0.032-0.125 0.117-0.119 0.149 0.011 0.3 0.012 0.446 0.037 0.198 0.034 0.314 0.159 0.346 0.361 0.042 0.272 0.083 0.545 0.129 0.816s0.094 0.542 0.15 0.811c0.033 0.157 0.040 0.157 0.203 0.157 0.66 0.001 1.32 0.001 1.98 0 0.045 0 0.092-0.007 0.146-0.012-0.010-0.053-0.016-0.094-0.026-0.134-0.121-0.472-0.179-0.953-0.237-1.435-0.027-0.22-0.053-0.441-0.102-0.656-0.093-0.41-0.342-0.675-0.768-0.755-0.075-0.014-0.148-0.043-0.222-0.065zM23.835 15.324c0.001 0 0.003 0 0.003 0 0-0.684 0.001-1.368-0.001-2.052 0-0.158-0.003-0.158-0.159-0.161-0.048-0.001-0.096 0-0.144 0-0.648 0-1.296-0.001-1.944-0.001-0.115 0-0.118 0-0.119 0.115-0.002 0.228-0.001 0.456-0.001 0.684 0 1.032 0.002 2.064-0.003 3.096-0.001 0.136-0.019 0.276-0.059 0.405-0.069 0.218-0.228 0.321-0.445 0.321-0.204 0-0.352-0.108-0.44-0.308-0.067-0.154-0.070-0.314-0.070-0.476 0-1.164 0-2.328 0-3.492 0-0.066 0.001-0.132 0-0.198-0.003-0.141-0.003-0.141-0.137-0.145-0.012-0.001-0.024 0-0.036 0-0.678 0-1.356 0-2.034-0.001-0.024 0-0.048-0.001-0.072-0.001-0.058 0.002-0.086 0.033-0.087 0.091 0 0.036-0.001 0.072-0.001 0.108 0 1.242-0.001 2.485 0.001 3.726 0 0.15 0.008 0.3 0.027 0.449 0.090 0.687 0.442 1.185 1.070 1.491 0.416 0.202 0.857 0.297 1.314 0.324 0.419 0.025 0.839 0.031 1.256-0.032 0.363-0.055 0.714-0.145 1.043-0.316 0.689-0.36 1.015-0.943 1.035-1.701 0.016-0.642 0.003-1.284 0.003-1.926zM41.254 19.312c0.579 0.011 1.094-0.076 1.582-0.298 0.428-0.195 0.779-0.488 1.045-0.874 0.349-0.507 0.502-1.085 0.545-1.69 0.035-0.492-0.006-0.981-0.142-1.459-0.158-0.556-0.448-1.032-0.895-1.399-0.411-0.338-0.898-0.523-1.418-0.597-0.523-0.074-1.049-0.072-1.571 0.049-0.651 0.15-1.194 0.454-1.606 0.998-0.269 0.354-0.426 0.748-0.527 1.167-0.095 0.392-0.109 0.796-0.084 1.198 0.045 0.719 0.23 1.389 0.712 1.951 0.241 0.282 0.53 0.502 0.867 0.653 0.488 0.219 1.002 0.32 1.492 0.301zM19.32 10.020v-0.001c-0.318 0-0.636 0-0.954 0-0.042 0-0.084 0-0.126 0.002-0.053 0.002-0.077 0.035-0.070 0.083 0.037 0.298 0.082 0.593 0.24 0.858 0.31 0.519 0.795 0.779 1.359 0.918 0.356 0.088 0.719 0.125 1.087 0.128 0.663 0.005 1.316-0.053 1.928-0.337 0.342-0.159 0.631-0.383 0.829-0.711 0.237-0.394 0.316-0.819 0.264-1.275-0.046-0.412-0.22-0.753-0.532-1.024-0.296-0.257-0.656-0.39-1.023-0.499-0.465-0.136-0.936-0.251-1.403-0.381-0.108-0.030-0.218-0.074-0.312-0.134-0.221-0.139-0.216-0.449 0.010-0.577 0.085-0.049 0.189-0.068 0.288-0.085 0.076-0.013 0.155-0.005 0.234-0.002 0.243 0.009 0.375 0.116 0.433 0.352 0.037 0.151 0.037 0.151 0.195 0.151 0.42 0 0.84 0 1.26 0 0.192 0 0.384-0.001 0.576 0.001 0.069 0.001 0.095-0.026 0.094-0.096-0.006-0.365-0.113-0.696-0.34-0.981-0.337-0.422-0.812-0.598-1.318-0.696-0.323-0.063-0.652-0.081-0.984-0.079-0.568 0.003-1.124 0.073-1.649 0.294-0.425 0.179-0.763 0.465-0.963 0.891-0.15 0.319-0.17 0.657-0.146 1.002 0.032 0.468 0.241 0.835 0.624 1.1 0.212 0.148 0.454 0.234 0.703 0.303 0.421 0.118 0.84 0.243 1.258 0.369 0.183 0.055 0.367 0.111 0.541 0.187 0.273 0.12 0.339 0.446 0.148 0.671-0.19 0.224-0.438 0.255-0.704 0.196-0.262-0.058-0.388-0.245-0.415-0.502-0.013-0.122-0.020-0.13-0.16-0.129-0.322 0.002-0.646 0.001-0.97 0.001zM32.269 8.809c0 0.822 0 1.644 0 2.466 0 0.15-0.002 0.3 0.001 0.45 0.002 0.12 0.004 0.121 0.117 0.125 0.042 0.001 0.084 0.001 0.126 0.001 1.35 0 2.7 0 4.050 0 0.084 0 0.168 0.002 0.252-0.001 0.119-0.003 0.123-0.004 0.125-0.122 0.003-0.192 0.001-0.384 0.001-0.576 0-0.24 0.001-0.48-0.001-0.72-0.001-0.115-0.004-0.116-0.123-0.12-0.036-0.001-0.072 0-0.108 0-0.642 0-1.284 0-1.926 0-0.048 0-0.096-0.002-0.144 0-0.075 0.003-0.108-0.032-0.107-0.108 0.003-0.12-0.001-0.24 0-0.36 0.003-0.292-0.035-0.262 0.256-0.262 0.57-0.001 1.14 0 1.71-0.001 0.171-0.001 0.173-0.003 0.173-0.17 0.001-0.216 0.001-0.432 0.001-0.648 0-0.198 0.001-0.396-0.001-0.594-0.002-0.126-0.006-0.127-0.134-0.133-0.030-0.001-0.060 0-0.090 0-0.564 0-1.128 0-1.692 0-0.042 0-0.084-0.001-0.126 0-0.069 0.001-0.097-0.035-0.097-0.101 0.001-0.15-0.002-0.3 0-0.45 0.002-0.139 0.003-0.142 0.139-0.143 0.288-0.002 0.576-0.001 0.864-0.001 0.39 0 0.78 0.001 1.17-0.001 0.139-0.001 0.159-0.016 0.16-0.134 0.003-0.432 0.003-0.864 0-1.296-0.001-0.115-0.016-0.123-0.124-0.129-0.024-0.001-0.048 0.001-0.072 0.001-1.398 0-2.795-0.001-4.194-0.001-0.212 0-0.207-0.026-0.207 0.201 0.001 0.942 0.001 1.884 0.001 2.826zM11.983 8.815v0c-0.001 0.192-0.001 0.384-0.001 0.576 0 0.768-0.001 1.536 0.001 2.304 0 0.153 0.003 0.156 0.146 0.156 1.458 0.001 2.916 0.001 4.374 0 0.14 0 0.142-0.003 0.143-0.138 0.002-0.336 0.001-0.672 0.001-1.008 0-0.096-0.003-0.192 0-0.288 0.002-0.077-0.033-0.109-0.108-0.104-0.042 0.003-0.084 0-0.126 0-0.564 0-1.128 0-1.692 0-0.12 0-0.24-0.003-0.36 0-0.077 0.002-0.107-0.034-0.106-0.109 0.002-0.12-0.003-0.24-0.001-0.36 0.003-0.295-0.037-0.261 0.255-0.262 0.576-0.002 1.152 0 1.728-0.003 0.168-0.001 0.172-0.007 0.173-0.174 0.001-0.402 0.001-0.804-0.001-1.206-0.001-0.158-0.005-0.158-0.163-0.162-0.030-0.001-0.060 0-0.090 0-0.558 0-1.116 0-1.674 0-0.042 0-0.084-0.001-0.126-0.001-0.065 0.001-0.101-0.026-0.101-0.095 0.001-0.174 0.001-0.348 0.001-0.522 0-0.051 0.024-0.079 0.075-0.079 0.036-0.001 0.072 0.002 0.108 0.002 0.654 0 1.308 0.001 1.962 0.001 0.172 0 0.172-0.001 0.173-0.182 0.001-0.318 0-0.636 0-0.954 0-0.102-0.002-0.204 0.001-0.306 0.002-0.084-0.036-0.122-0.119-0.118-0.030 0.001-0.060 0-0.090 0-1.392 0-2.784 0-4.176 0-0.036 0-0.072 0.003-0.108 0-0.070-0.005-0.097 0.033-0.098 0.097 0 0.042-0.001 0.084-0.001 0.126 0.002 0.937 0.002 1.873 0.002 2.809zM27.949 5.783c-0.042 0-0.084 0-0.126 0-0.792 0-1.584 0.001-2.376 0-0.239 0-0.193 0.024-0.193 0.199-0.002 0.42-0.002 0.84-0.001 1.26 0.001 0.139 0.003 0.142 0.141 0.143 0.372 0.002 0.744 0.001 1.116 0.001 0.275 0 0.254-0.021 0.254 0.251 0 1.35 0 2.699 0 4.049 0 0.164 0.001 0.165 0.166 0.165 0.654 0.001 1.308 0.001 1.962 0 0.259-0.001 0.238 0.028 0.238-0.246 0-1.338-0.001-2.675-0.001-4.013 0-0.205 0.001-0.206 0.209-0.207 0.378-0.001 0.756 0.001 1.134-0.001 0.157-0.001 0.167-0.008 0.168-0.16 0.003-0.438 0.002-0.875 0-1.314-0.001-0.12-0.005-0.122-0.119-0.127-0.042-0.002-0.084-0.001-0.126-0.001-0.814 0.001-1.63 0.001-2.446 0.001zM36.364 16.147c0-0.931 0-1.861 0-2.791 0-0.036 0.001-0.072 0-0.108-0.003-0.132-0.004-0.132-0.127-0.137-0.030-0.001-0.060 0-0.090 0-0.643 0-1.285 0-1.927 0-0.242 0-0.224-0.019-0.224 0.223 0 1.873 0 3.746 0 5.619 0 0.036 0.001 0.072 0.001 0.108 0.001 0.065 0.030 0.101 0.098 0.101 0.042 0 0.084 0.001 0.126 0.001 0.595 0 1.188 0 1.783 0 0.084 0 0.168-0.005 0.252 0.001 0.090 0.006 0.118-0.035 0.109-0.117-0.003-0.029-0.001-0.060-0.001-0.090 0-0.936 0-1.873 0-2.81zM54.108 12.38c0 2.058 0 4.116 0 6.175 0 0.138 0.004 0.276 0.001 0.414-0.002 0.083 0.026 0.121 0.114 0.118 0.126-0.005 0.252 0 0.378-0.001 0.236-0.002 0.223 0.031 0.223-0.222 0-4.296 0-8.593 0.001-12.889 0-0.054-0.003-0.108 0-0.162 0.004-0.074-0.025-0.109-0.104-0.108-0.168 0.003-0.336 0.003-0.504-0.001-0.079-0.002-0.107 0.032-0.106 0.106 0.001 0.15-0.002 0.3-0.002 0.449-0.001 2.040-0.001 4.081-0.001 6.12zM59.541 12.452c0 2.131 0 4.262 0 6.393 0 0.030-0.001 0.060 0 0.090 0.004 0.12 0.004 0.123 0.118 0.124 0.156 0.002 0.312 0.001 0.468-0.001 0.118-0.002 0.119-0.005 0.123-0.12 0.001-0.030 0-0.060 0-0.090 0-4.22 0-8.44 0-12.659 0-0.060 0-0.12-0.001-0.18-0.003-0.17-0.003-0.17-0.164-0.172-0.108-0.001-0.216-0.001-0.324-0.001-0.263-0.001-0.22-0.005-0.22 0.224-0.001 2.131-0.001 4.261-0.001 6.392zM62.523 6.538c0.016-0.415-0.323-0.785-0.761-0.785-0.465 0-0.783 0.339-0.783 0.762 0 0.424 0.276 0.765 0.762 0.788 0.42 0.021 0.779-0.342 0.782-0.764zM41.051 7.724c0-0.156 0.003-0.312-0.001-0.468-0.002-0.084 0.029-0.124 0.115-0.117 0.167 0.013 0.336 0.013 0.501 0.042 0.232 0.040 0.374 0.193 0.404 0.401 0.040 0.278-0.061 0.519-0.278 0.632-0.208 0.108-0.435 0.123-0.665 0.113-0.065-0.003-0.075-0.047-0.075-0.099 0-0.168 0-0.335 0-0.503zM40.623 16.141c0.035-0.351 0.065-0.701 0.109-1.051 0.013-0.104 0.058-0.207 0.102-0.304 0.092-0.205 0.264-0.284 0.479-0.284 0.219 0 0.387 0.093 0.467 0.3 0.060 0.155 0.114 0.317 0.135 0.481 0.063 0.488 0.075 0.979 0.021 1.469-0.019 0.172-0.047 0.343-0.080 0.513-0.015 0.075-0.047 0.148-0.081 0.218-0.097 0.198-0.26 0.289-0.479 0.285s-0.374-0.1-0.469-0.3c-0.123-0.261-0.15-0.54-0.169-0.821-0.011-0.167-0.002-0.335-0.002-0.503-0.012-0.001-0.023-0.001-0.034-0.003zM61.061 6.532c-0.006-0.391 0.292-0.714 0.68-0.714 0.403 0 0.691 0.291 0.694 0.696 0.005 0.43-0.282 0.724-0.685 0.723-0.402-0.001-0.67-0.282-0.69-0.705zM61.879 6.57c0.054-0.019 0.088-0.030 0.12-0.044 0.107-0.044 0.164-0.131 0.155-0.234-0.010-0.106-0.083-0.184-0.201-0.193-0.137-0.010-0.275-0.004-0.412-0.005-0.062-0.001-0.084 0.031-0.083 0.089 0.003 0.125 0.004 0.251 0.005 0.376 0 0.108-0.005 0.215-0.002 0.323 0.001 0.024 0.026 0.046 0.040 0.069 0.015-0.021 0.042-0.041 0.044-0.063 0.006-0.071 0.001-0.143 0.005-0.215 0.005-0.109 0.019-0.118 0.126-0.122 0.079-0.003 0.122 0.038 0.158 0.096 0.054 0.086 0.105 0.174 0.16 0.259 0.028 0.044 0.063 0.069 0.12 0.028-0.076-0.118-0.15-0.233-0.234-0.365zM61.76 6.144c0.053 0.005 0.113 0.009 0.172 0.018 0.075 0.012 0.115 0.065 0.122 0.135 0.008 0.077-0.020 0.15-0.105 0.163-0.111 0.018-0.224 0.023-0.336 0.026-0.019 0.001-0.055-0.034-0.057-0.054-0.008-0.077-0.008-0.155-0.002-0.232 0.001-0.020 0.035-0.049 0.058-0.053 0.045-0.009 0.094-0.003 0.148-0.003z"></path></svg>',
			)
		);
	}

	/**
	 * Initialize the module.
	 */
	public function init() {
		$this->register_hooks();
	}

	/**
	 * Register submodule hooks
	 */
	public function register_hooks() {
		add_action( 'woocommerce_after_cart_totals', array( $this, 'display_payment_icons_after_cart_totals' ) );
	}

	/**
	 * Display payment icons after cart totals.
	 */
	public function display_payment_icons_after_cart_totals() {

		if ( ! self::should_load() ) {
			return;
		}
		echo '<div class="nv-payment-cart-total">';
		echo self::render_payment_icons(); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}

	/**
	 * Static method that renders the payment icons.
	 * This method is static because we need to call it in footer component too.
	 *
	 * @return string
	 */
	public static function render_payment_icons() {
		$payment_icons = get_theme_mod( 'neve_payment_icons_new', \Neve_Pro\Modules\Woocommerce_Booster\Customizer\Payment_Icons::get_payment_icons_default_value() );
		$payment_icons = json_decode( $payment_icons, true );
		$html_result   = '';
		if ( empty( $payment_icons ) ) {
			return $html_result;
		}

		$html_result .= '<div class="nv-payment-icons-wrapper">';

		foreach ( $payment_icons as $payment_method ) {
			if ( $payment_method['visibility'] !== 'yes' ) {
				continue;
			}
			$slug                = array_key_exists( 'slug', $payment_method ) ? $payment_method['slug'] : 'custom-icon';
			$has_predefined_icon = array_key_exists( $slug, self::$payment_icons );
			$has_svg_icon        = array_key_exists( 'svg', $payment_method ) && ! empty( $payment_method['svg'] );
			if ( ! $has_predefined_icon && ! $has_svg_icon ) {
				continue;
			}
			$html_result .= '<div class="nv-payment-icon ' . esc_attr( $slug ) . '">';
			if ( $has_predefined_icon ) {
				$html_result .= self::$payment_icons[ $slug ];
			}
			if ( $has_svg_icon ) {
				$html_result .= $payment_method['svg'];
			}
			$html_result .= '</div>';
		}
		$html_result .= '</div>';
		return $html_result;
	}
}
